/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.ci;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.ci.Credential;
import com.xebialabs.deployit.ci.DeployableView;
import com.xebialabs.deployit.ci.DeployitCliCache;
import com.xebialabs.deployit.ci.DeployitCliCallback;
import com.xebialabs.deployit.ci.DeployitCliTemplate;
import com.xebialabs.deployit.ci.JenkinsDeploymentOptions;
import com.xebialabs.deployit.ci.JenkinsImportOptions;
import com.xebialabs.deployit.ci.JenkinsPackageOptions;
import com.xebialabs.deployit.ci.Messages;
import com.xebialabs.deployit.ci.VersionKind;
import com.xebialabs.deployit.ci.util.DeployitTypes;
import com.xebialabs.deployit.ci.util.JenkinsDeploymentListener;
import com.xebialabs.deployit.client.DarPackager;
import com.xebialabs.deployit.client.Deployable;
import com.xebialabs.deployit.client.DeployitCli;
import com.xebialabs.deployit.client.DeploymentListener;
import com.xebialabs.deployit.client.DeploymentOptions;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeployitNotifier
extends Notifier {
    public final String credential;
    public final String application;
    public final String version;
    public final JenkinsPackageOptions packageOptions;
    public final JenkinsImportOptions importOptions;
    public final JenkinsDeploymentOptions deploymentOptions;
    protected transient DeployitTypes deployitTypes;

    @DataBoundConstructor
    public DeployitNotifier(String credential, String application, String version, JenkinsPackageOptions packageOptions, JenkinsImportOptions importOptions, JenkinsDeploymentOptions deploymentOptions) {
        this.credential = credential;
        this.application = application;
        this.version = version;
        this.packageOptions = packageOptions;
        this.importOptions = importOptions;
        this.deploymentOptions = deploymentOptions;
    }

    private DeployitTypes getDeployitTypes() {
        if (this.deployitTypes == null) {
            this.deployitTypes = new DeployitTypes(this.getCliTemplate().getDescriptors());
        }
        return this.deployitTypes;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public boolean perform(final AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        final JenkinsDeploymentListener deploymentListener = new JenkinsDeploymentListener(listener, this.deploymentOptions == null ? false : this.deploymentOptions.verbose);
        final EnvVars envVars = build.getEnvironment((TaskListener)listener);
        String resolvedVersion = envVars.expand(this.version);
        if (this.packageOptions != null) {
            deploymentListener.info(Messages.DeployitNotifier_package(this.application));
            deploymentListener.handleInfo("packaged version is " + resolvedVersion);
            FilePath workspace = build.getWorkspace();
            if (this.deploymentOptions != null && this.deploymentOptions.versionKind == VersionKind.Packaged) {
                this.deploymentOptions.setVersion(resolvedVersion);
            }
            File targetDir = new File(workspace.absolutize().getRemote(), "deployitpackage");
            DarPackager packager = new DarPackager(this.getApplicationName(), resolvedVersion, targetDir, (DeploymentListener)deploymentListener);
            packager.addDeployables(Collections2.transform(this.packageOptions.deployables, (Function)new Function<DeployableView, Deployable>(){

                public Deployable apply(DeployableView artifactView) {
                    return artifactView.newDeployable(DeployitNotifier.this.getDeployitTypes(), build.getWorkspace(), envVars, deploymentListener);
                }
            }));
            File packaged = packager.perform();
            deploymentListener.info(Messages.DeployitNotifier_packaged(this.application, packaged));
            if (this.importOptions != null) {
                this.importOptions.setGeneratedDarLocation(packaged);
            }
        }
        if (this.importOptions != null) {
            try {
                final String darFileLocation = this.importOptions.getDarFileLocation(build.getWorkspace(), deploymentListener);
                deploymentListener.info(Messages.DeployitNofifier_import(darFileLocation));
                this.getCliTemplate().perform(new DeployitCliCallback<ConfigurationItem>(){

                    @Override
                    public ConfigurationItem call(DeployitCli cli) {
                        return cli.importPackage(darFileLocation, (DeploymentListener)deploymentListener);
                    }
                });
                deploymentListener.info(Messages.DeployitNotifier_imported(darFileLocation));
            }
            catch (Exception e) {
                e.printStackTrace(listener.getLogger());
                deploymentListener.error(Messages.DeployitNotifier_import_error(this.importOptions, e.getMessage()));
                return false;
            }
        }
        if (this.deploymentOptions != null) {
            deploymentListener.info(Messages.DeployitNofifier_startDeployment(this.application, this.deploymentOptions.environment));
            String packageVersion = null;
            switch (this.deploymentOptions.versionKind) {
                case Other: {
                    packageVersion = resolvedVersion;
                    break;
                }
                case Packaged: {
                    packageVersion = this.deploymentOptions.getVersion();
                    break;
                }
                case LatestImported: {
                    throw new RuntimeException("LatestImported Option not yet implemented");
                }
            }
            final String versionId = Joiner.on((String)"/").join((Object)this.application, (Object)packageVersion, new Object[0]);
            deploymentListener.info(Messages.DeployitNofifier_deploy(versionId, this.deploymentOptions.environment));
            try {
                this.getCliTemplate().perform(new DeployitCliCallback<String>(){

                    @Override
                    public String call(DeployitCli cli) {
                        return cli.deploy(versionId, DeployitNotifier.this.deploymentOptions.environment, Collections.emptyList(), (DeploymentOptions)DeployitNotifier.this.deploymentOptions, (DeploymentListener)deploymentListener);
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace(listener.getLogger());
                deploymentListener.error(Messages._DeployitNofifier_errorDeploy(e.getMessage()));
                return false;
            }
            deploymentListener.info(Messages.DeployitNofifier_endDeployment(this.application, this.deploymentOptions.environment));
        }
        return true;
    }

    private String getApplicationName() {
        return this.application.substring(this.application.lastIndexOf("/") + 1);
    }

    private DeployitCliTemplate getCliTemplate() {
        return this.getDescriptor().getCliTemplate(this.credential);
    }

    public DeployitDescriptor getDescriptor() {
        return (DeployitDescriptor)super.getDescriptor();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DeployitDescriptor
    extends BuildStepDescriptor<Publisher> {
        private String deployitServerUrl;
        private List<Credential> credentials = Lists.newArrayList();
        private final DeployitCliCache deployitCliCache;

        public DeployitDescriptor() {
            this.load();
            this.deployitCliCache = new DeployitCliCache(this.deployitServerUrl);
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            this.deployitServerUrl = json.get("deployitServerUrl").toString();
            this.credentials = req.bindJSONToList(Credential.class, json.get("credentials"));
            this.save();
            this.deployitCliCache.setDeployitServerUrl(this.deployitServerUrl);
            return true;
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return Messages.DeployitNotifier_displayName();
        }

        public List<Credential> getCredentials() {
            return this.credentials;
        }

        public String getDeployitServerUrl() {
            return this.deployitServerUrl;
        }

        public ListBoxModel doFillCredentialItems() {
            ListBoxModel m = new ListBoxModel();
            for (Credential c : this.credentials) {
                m.add(c.name, c.name);
            }
            return m;
        }

        public Publisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return (Publisher)super.newInstance(req, formData);
        }

        public List<String> environments(String credential) {
            return this.getCliTemplate(credential).perform(new DeployitCliCallback<List<String>>(){

                @Override
                public List<String> call(DeployitCli cli) {
                    return cli.search("udm.Environment");
                }
            });
        }

        public FormValidation doCheckApplication(@QueryParameter String credential, final @QueryParameter String value) {
            if ("Applications/".equals(value)) {
                return FormValidation.ok((String)"Fill the application id, eg Applications/PetClinic-ear");
            }
            String type = "udm.Application";
            try {
                ConfigurationItem repositoryObject = this.getCliTemplate(credential).perform(new DeployitCliCallback<ConfigurationItem>(){

                    @Override
                    public ConfigurationItem call(DeployitCli cli) {
                        return cli.get(value);
                    }
                });
                if (repositoryObject.getType().toString().equals("udm.Application")) {
                    return FormValidation.ok();
                }
                return FormValidation.error((String)"CI found but with the wrong type, expected %s, found %s", (Object[])new Object[]{"udm.Application", repositoryObject.getType()});
            }
            catch (Exception e) {
                return FormValidation.error((String)"%s. Candidates %s", (Object[])new Object[]{e.getMessage(), this.getCandidates(credential, value, "udm.Application")});
            }
        }

        private Collection<String> getCandidates(String credential, final String value, final String type) {
            try {
                List<String> search = this.getCliTemplate(credential).perform(new DeployitCliCallback<List<String>>(){

                    @Override
                    public List<String> call(DeployitCli cli) {
                        return cli.search(type);
                    }
                });
                return Collections2.filter(search, (Predicate)new Predicate<String>(){

                    public boolean apply(@Nullable String input) {
                        return input.startsWith(value);
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
                return Collections.emptyList();
            }
        }

        private DeployitCliTemplate getCliTemplate(String credentialName) {
            ImmutableMap map = Maps.uniqueIndex(this.credentials, Credential.CREDENTIAL_INDEX);
            if (!map.containsKey(credentialName)) {
                throw new RuntimeException("Credential (" + credentialName + ") not found in " + map.keySet());
            }
            Credential c = (Credential)((Object)map.get(credentialName));
            try {
                return this.deployitCliCache.getCliTemplate(c);
            }
            catch (ExecutionException e) {
                throw new RuntimeException("error", e);
            }
        }

        public List<String> getAllResourceTypes() {
            return this.deployitCliCache.resources(this.getDefaultCredential());
        }

        public List<String> getAllArtifactTypes() {
            return this.deployitCliCache.artifacts(this.getDefaultCredential());
        }

        public List<String> getPropertiesOf(String type) {
            return this.deployitCliCache.getPropertiesIndexedByType(this.getDefaultCredential()).get(type);
        }

        private Credential getDefaultCredential() {
            if (this.credentials.isEmpty()) {
                throw new RuntimeException("No credentials defined in the system configuration");
            }
            return this.credentials.iterator().next();
        }
    }
}

