/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.ci;

import com.google.common.base.Function;
import com.xebialabs.deployit.ci.DeployitCliCallback;
import com.xebialabs.deployit.ci.DeployitCliTemplate;
import com.xebialabs.deployit.client.DeployitCli;
import com.xebialabs.deployit.engine.api.dto.ServerInfo;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import hudson.util.Secret;
import java.io.IOException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Credential
extends AbstractDescribableImpl<Credential> {
    public static final Function<Credential, String> CREDENTIAL_INDEX = new Function<Credential, String>(){

        public String apply(Credential input) {
            return input.getName();
        }
    };
    public final String name;
    public final String username;
    public final Secret password;

    @DataBoundConstructor
    public Credential(String name, String username, Secret password) {
        this.name = name;
        this.username = username;
        this.password = password;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class CredentialDescriptor
    extends Descriptor<Credential> {
        public String getDisplayName() {
            return "Credential";
        }

        public FormValidation doValidate(@QueryParameter String deployitServerUrl, @QueryParameter String username, @QueryParameter Secret password) throws IOException {
            try {
                ServerInfo info = new DeployitCliTemplate(deployitServerUrl, username, password).perform(new DeployitCliCallback<ServerInfo>(){

                    @Override
                    public ServerInfo call(DeployitCli cli) {
                        return cli.info();
                    }
                });
                return FormValidation.ok((String)"Your Deployit instance version %s is alive, and your credentials are valid !", (Object[])new Object[]{info.getVersion()});
            }
            catch (Exception e) {
                e.printStackTrace();
                return FormValidation.error((String)"Deployit configuration is not valid ! %s ", (Object[])new Object[]{e.getMessage()});
            }
        }
    }
}

