/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.ci.bamboo.util;

import com.xebialabs.deployit.ci.bamboo.util.CollectionUtils;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.IteratorUtils;
import org.junit.Assert;
import org.junit.Test;

public class CollectionUtilsTest {
    @Test
    public void testConcatIterables() throws Exception {
        LinkedHashSet<Object> iter1 = new LinkedHashSet();
        LinkedHashSet<Object> iter2 = new LinkedHashSet();
        Iterable i = CollectionUtils.concatIterables(iter1, iter2);
        this.compareIterables(i, new String[0]);
        iter1 = null;
        iter2 = null;
        i = CollectionUtils.concatIterables(iter1, iter2);
        this.compareIterables(i, new String[0]);
        iter1 = new LinkedHashSet<String>(Arrays.asList("a", "b", "c"));
        iter2 = new LinkedHashSet<String>(Arrays.asList("1", "2"));
        i = CollectionUtils.concatIterables(iter1, iter2);
        this.compareIterables(i, new String[]{"a", "b", "c", "1", "2"});
        iter1 = new LinkedHashSet();
        iter2 = new LinkedHashSet<String>(Arrays.asList("1", "2"));
        i = CollectionUtils.concatIterables(iter1, iter2);
        this.compareIterables(i, new String[]{"1", "2"});
        iter1 = new LinkedHashSet<String>(Arrays.asList("a", "b", "c"));
        iter2 = new LinkedHashSet();
        i = CollectionUtils.concatIterables(iter1, iter2);
        this.compareIterables(i, new String[]{"a", "b", "c"});
    }

    @Test
    public void testTrimAndJoin() throws Exception {
        String s = CollectionUtils.trimAndJoin((String)",", (String[])new String[0]);
        Assert.assertEquals((Object)"", (Object)s);
        s = CollectionUtils.trimAndJoin((String)",", null);
        Assert.assertEquals((Object)"", (Object)s);
        s = CollectionUtils.trimAndJoin((String)",", (String[])new String[]{"1"});
        Assert.assertEquals((Object)"1", (Object)s);
        s = CollectionUtils.trimAndJoin((String)",", (String[])new String[]{"a", " b ", "", "c "});
        Assert.assertEquals((Object)"a,b,c", (Object)s);
    }

    @Test
    public void testSplitAndTrimToList() throws Exception {
        List l = CollectionUtils.splitAndTrimToList((String)"", (String)",");
        Assert.assertArrayEquals((Object[])new String[0], (Object[])l.toArray());
        l = CollectionUtils.splitAndTrimToList(null, (String)",");
        Assert.assertArrayEquals((Object[])new String[0], (Object[])l.toArray());
        l = CollectionUtils.splitAndTrimToList((String)"a   , b,,  ,c, d", (String)",");
        Assert.assertArrayEquals((Object[])new String[]{"a", "b", "c", "d"}, (Object[])l.toArray());
    }

    private void compareIterables(Iterable a, String[] s) {
        Object[] o2 = IteratorUtils.toArray(a.iterator());
        Assert.assertArrayEquals((Object[])s, (Object[])o2);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testImmutableSet() throws Exception {
        Set s = CollectionUtils.immutableSet((Object[])new String[]{"a", "b", "c"});
        Assert.assertEquals((long)3L, (long)s.size());
        s.add("d");
    }
}

