/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.ci.bamboo.util;

import com.xebialabs.xlplatform.utils.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class CollectionUtils {
    public static <T> Set<T> immutableSet(T ... items) {
        return Collections.unmodifiableSet(new HashSet<T>(Arrays.asList(items)));
    }

    public static Iterable concatIterables(Set set1, Set set2) {
        LinkedHashSet s = new LinkedHashSet();
        if (set1 != null) {
            s.addAll(set1);
        }
        if (set2 != null) {
            s.addAll(set2);
        }
        return s;
    }

    public static String trimAndJoin(String delimiter, String ... list) {
        return Strings.mkString(CollectionUtils.stringArrayTrimmedList(list), (String)delimiter);
    }

    public static List<String> splitAndTrimToList(String str, String delimiter) {
        String[] s = str != null ? str.split(delimiter) : new String[]{};
        return CollectionUtils.stringArrayTrimmedList(s);
    }

    public static List<String> stringArrayTrimmedList(String[] array) {
        ArrayList<String> o = new ArrayList<String>();
        if (array != null) {
            for (String s : array) {
                if ((s = s.trim()).isEmpty()) continue;
                o.add(s);
            }
        }
        return o;
    }
}

