/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.ci.bamboo.configuration;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.google.common.collect.ImmutableSet;
import com.xebialabs.deployit.ci.bamboo.configuration.AbstractDeployitConfigurator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class DeployAppConfigurator
extends AbstractDeployitConfigurator {
    private static final Logger log = Logger.getLogger(DeployAppConfigurator.class);
    public static final String DEPLOYIT_ENVIRONMENT = "deployitEnvironment";
    public static final String DEPLOYIT_APPLICATION = "deployitApplication";
    public static final String DEPLOYIT_VERSION = "deployitVersion";
    public static final String DEPLOYIT_ORCHESTRATOR = "deployitOrchestrator";
    public static final String DEPLOYIT_UPDATEDEPLOYEDS = "deployitUpdateDeployeds";
    public static final String DEPLOYIT_FAILACTION = "deployitFailAction";
    private static final Set<String> FIELDS_TO_COPY = ImmutableSet.of((Object)"deployitEnvironment", (Object)"deployitApplication", (Object)"deployitVersion", (Object)"deployitOrchestrator", (Object)"deployitUpdateDeployeds", (Object)"deployitFailAction", (Object[])new String[0]);

    @Override
    protected Set<String> getExtraFieldsToCopy() {
        return FIELDS_TO_COPY;
    }

    @Override
    public void populateContextForCreate(Map<String, Object> context) {
        super.populateContextForCreate(context);
        context.put(DEPLOYIT_ENVIRONMENT, "Environments/");
        context.put(DEPLOYIT_APPLICATION, "Applications/");
        context.put(DEPLOYIT_ORCHESTRATOR, "");
        context.put(DEPLOYIT_UPDATEDEPLOYEDS, "true");
    }

    @Override
    public void validate(ActionParametersMap params, ErrorCollection errorCollection) {
        log.debug((Object)"DeployUpgradeConfigurator.validate");
        log.debug((Object)("params " + params));
        super.validate(params, errorCollection);
        this.validateAttribute(params, errorCollection, DEPLOYIT_ENVIRONMENT, "deployit.environment.error");
        this.validateAttribute(params, errorCollection, DEPLOYIT_APPLICATION, "deployit.application.error");
        String version = params.getString(DEPLOYIT_VERSION);
        if (StringUtils.isEmpty((String)version)) {
            errorCollection.addError(DEPLOYIT_VERSION, this.textProvider.getText("deployit.version.error"));
        }
    }
}

