/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.ci.bamboo.tasks;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.configuration.ConfigurationMap;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.CommonTaskType;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.xebialabs.deployit.booter.remote.BooterConfig;
import com.xebialabs.deployit.booter.remote.DeployitCommunicator;
import com.xebialabs.deployit.booter.remote.RemoteBooter;
import com.xebialabs.deployit.ci.bamboo.client.DeployitException;
import com.xebialabs.deployit.ci.bamboo.util.EncryptionKeys;
import com.xebialabs.deployit.ci.bamboo.util.RemoteBooterConfigurer;
import com.xebialabs.deployit.encryption.AESPasswordEncrypter;
import java.net.MalformedURLException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDeployitTask
implements CommonTaskType {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractDeployitTask.class);
    private static boolean booterConfigured = false;
    public static final int DEFAULT_SOCKET_TIMEOUT = 300000;
    private DeployitCommunicator communicator;
    private static final AESPasswordEncrypter AES_PASSWORD_ENCRYPTER = new AESPasswordEncrypter(EncryptionKeys.DEFAULT_PASSWORD_ENCRYPTION_KEY);

    abstract void doExecute(CommonTaskContext var1, DeployitCommunicator var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskResult execute(CommonTaskContext taskContext) throws TaskException {
        TaskResultBuilder taskResultBuilder = TaskResultBuilder.newBuilder((CommonTaskContext)taskContext);
        BuildLogger buildLogger = taskContext.getBuildLogger();
        ConfigurationMap configurationMap = taskContext.getConfigurationMap();
        String username = (String)configurationMap.get((Object)"deployitUsername");
        String password = AES_PASSWORD_ENCRYPTER.isEncrypted((String)configurationMap.get((Object)"deployitPassword")) ? AES_PASSWORD_ENCRYPTER.decrypt((String)configurationMap.get((Object)"deployitPassword")) : (String)configurationMap.get((Object)"deployitPassword");
        String serverUrl = (String)configurationMap.get((Object)"deployitServerUrl");
        Thread currentThread = Thread.currentThread();
        ClassLoader origClassLoader = currentThread.getContextClassLoader();
        ClassLoader taskClassLoader = DeployitCommunicator.class.getClassLoader();
        try {
            LOGGER.debug("Setting context classloader: {}", (Object)taskClassLoader);
            currentThread.setContextClassLoader(taskClassLoader);
            this.doExecute(taskContext, this.boot(serverUrl, username, password));
            taskResultBuilder.success();
        }
        catch (DeployitException e) {
            buildLogger.addErrorLogEntry(e.getMessage());
            taskResultBuilder.failedWithError();
        }
        catch (Exception e) {
            buildLogger.addErrorLogEntry(e.getMessage(), (Throwable)e);
            taskResultBuilder.failedWithError();
        }
        finally {
            LOGGER.debug("Restoring context classloader: {}", (Object)origClassLoader);
            currentThread.setContextClassLoader(origClassLoader);
        }
        return taskResultBuilder.build();
    }

    protected DeployitCommunicator boot(String serverUrl, String username, String password) throws MalformedURLException {
        BooterConfig config;
        URL server = new URL(serverUrl);
        if (!booterConfigured) {
            RemoteBooterConfigurer.preconfigure();
            booterConfigured = true;
        }
        int port = server.getPort();
        try {
            config = BooterConfig.builder().withProtocol(BooterConfig.Protocol.valueOf((String)server.getProtocol().toUpperCase())).withCredentials(username, password).withHost(server.getHost()).withSocketTimeout(300000).withPort(port == -1 ? server.getDefaultPort() : port).withContext(server.getPath()).build();
        }
        catch (IllegalArgumentException e) {
            throw new DeployitException(String.format("Error while trying to access XL Deploy with server URL: %s", serverUrl));
        }
        return RemoteBooter.boot((BooterConfig)config);
    }
}

