/*
 * Decompiled with CFR 0.152.
 */
package ut.ut.com.xebialabs.deployit.ci.bamboo.client;

import com.xebialabs.deployit.booter.remote.BooterConfig;
import com.xebialabs.deployit.booter.remote.DeployitCommunicator;
import com.xebialabs.deployit.booter.remote.RemoteBooter;
import com.xebialabs.deployit.ci.bamboo.client.CiDeploy;
import com.xebialabs.deployit.ci.bamboo.client.DeployOptions;
import com.xebialabs.deployit.ci.bamboo.client.DeployitException;
import com.xebialabs.restito.builder.stub.StubHttp;
import com.xebialabs.restito.builder.verify.VerifyHttp;
import com.xebialabs.restito.builder.verify.VerifySequenced;
import com.xebialabs.restito.semantics.Action;
import com.xebialabs.restito.semantics.Condition;
import com.xebialabs.restito.semantics.Stub;
import com.xebialabs.restito.server.StubServer;
import com.xebialabs.restito.support.junit.ServerDependencyRule;
import org.glassfish.grizzly.http.Method;
import org.glassfish.grizzly.http.util.HttpStatus;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class CiDeployTest {
    @Rule
    public ServerDependencyRule serverDependencyRule = new ServerDependencyRule();
    private StubServer stubServer;
    private DeployitCommunicator communicator;

    @Before
    public void setUp() throws Exception {
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
        this.stubServer = new StubServer(new Stub[0]).run();
        StubHttp.whenHttp((StubServer)this.stubServer).match(new Condition[]{Condition.get((String)"/deployit/server/info")}).then(new Action[]{Action.success()});
        StubHttp.whenHttp((StubServer)this.stubServer).match(new Condition[]{Condition.get((String)"/deployit/metadata/type")}).then(new Action[]{Action.success()});
        this.communicator = RemoteBooter.boot((BooterConfig)BooterConfig.builder().withProtocol(BooterConfig.Protocol.HTTP).withCredentials("admin", "admin").withHost("localhost").withPort(this.stubServer.getPort()).build());
    }

    @After
    public void tearDown() {
        this.stubServer.stop();
        this.communicator.shutdown();
    }

    @Test
    public void shouldPerformNormalDeployment() {
        this.setupDefaultDeployment();
        CiDeploy deployer = new CiDeploy(this.communicator);
        DeployOptions options = new DeployOptions("Applications/AnimalZoo-ear/1.0", "Environments/10smallEnv10");
        deployer.deploy(options);
        this.verifyStartInitialDeployment().then().once(new Condition[]{Condition.method((Method)Method.POST), Condition.uri((String)"/deployit/deployment")}).then().once(new Condition[]{Condition.method((Method)Method.POST), Condition.uri((String)"/deployit/task/7717458d-ede4-4112-bdc4-b77c6dc385f9/start")}).then().once(new Condition[]{Condition.method((Method)Method.GET), Condition.uri((String)"/deployit/task/7717458d-ede4-4112-bdc4-b77c6dc385f9")}).then().once(new Condition[]{Condition.method((Method)Method.GET), Condition.uri((String)"/deployit/task/7717458d-ede4-4112-bdc4-b77c6dc385f9/step/1")}).then().once(new Condition[]{Condition.method((Method)Method.POST), Condition.uri((String)"/deployit/task/7717458d-ede4-4112-bdc4-b77c6dc385f9/archive")});
    }

    @Test
    public void shouldPerformUpdateWhenDeployedApplicationExists() {
        this.setupDefaultDeployment();
        StubHttp.whenHttp((StubServer)this.stubServer).match(new Condition[]{Condition.get((String)"/deployit/repository/exists/Environments/10smallEnv10/AnimalZoo-ear")}).then(new Action[]{Action.stringContent((String)"<boolean>true</boolean>"), this.xmlContentType()});
        StubHttp.whenHttp((StubServer)this.stubServer).match(new Condition[]{Condition.get((String)"/deployit/deployment/prepare/update"), Condition.parameter((String)"deployedApplication", (String[])new String[]{"Environments/10smallEnv10/AnimalZoo-ear"}), Condition.parameter((String)"version", (String[])new String[]{"Applications/AnimalZoo-ear/1.0"})}).then(new Action[]{Action.resourceContent((String)"restito/deployit_deployment_prepare_update.xml"), this.xmlContentType()});
        CiDeploy deployer = new CiDeploy(this.communicator);
        DeployOptions options = new DeployOptions("Applications/AnimalZoo-ear/1.0", "Environments/10smallEnv10");
        options.setOrchestrator("default,container-by-container");
        deployer.deploy(options);
        VerifyHttp.verifyHttp((StubServer)this.stubServer).once(new Condition[]{Condition.method((Method)Method.GET), Condition.uri((String)"/deployit/deployment/prepare/update"), Condition.parameter((String)"deployedApplication", (String[])new String[]{"Environments/10smallEnv10/AnimalZoo-ear"}), Condition.parameter((String)"version", (String[])new String[]{"Applications/AnimalZoo-ear/1.0"})}).then().once(new Condition[]{Condition.method((Method)Method.POST), Condition.uri((String)"/deployit/deployment/prepare/deployeds")});
        VerifyHttp.verifyHttp((StubServer)this.stubServer).never(new Condition[]{Condition.method((Method)Method.GET), Condition.uri((String)"/deployit/deployment/prepare/initial")});
    }

    @Test(expected=DeployitException.class)
    public void shouldFailOnValidationErrors() {
        this.setupDefaultDeployment();
        StubHttp.whenHttp((StubServer)this.stubServer).match(new Condition[]{Condition.post((String)"/deployit/deployment/validate")}).then(new Action[]{Action.resourceContent((String)"restito/deployit_deployment_validate_witherrors.xml"), this.xmlContentType()});
        try {
            CiDeploy deployer = new CiDeploy(this.communicator);
            DeployOptions options = new DeployOptions("Applications/AnimalZoo-ear/1.0", "Environments/10smallEnv10");
            deployer.deploy(options);
        }
        catch (Throwable throwable) {
            this.verifyStartInitialDeployment().then().never(new Condition[]{Condition.method((Method)Method.POST), Condition.uri((String)"/deployit/deployment")}).then().never(new Condition[]{Condition.method((Method)Method.POST), Condition.uri((String)"/deployit/task/7717458d-ede4-4112-bdc4-b77c6dc385f9/start")}).then().never(new Condition[]{Condition.method((Method)Method.GET), Condition.uri((String)"/deployit/task/7717458d-ede4-4112-bdc4-b77c6dc385f9")}).then().never(new Condition[]{Condition.method((Method)Method.POST), Condition.uri((String)"/deployit/task/7717458d-ede4-4112-bdc4-b77c6dc385f9/archive")});
            throw throwable;
        }
        this.verifyStartInitialDeployment().then().never(new Condition[]{Condition.method((Method)Method.POST), Condition.uri((String)"/deployit/deployment")}).then().never(new Condition[]{Condition.method((Method)Method.POST), Condition.uri((String)"/deployit/task/7717458d-ede4-4112-bdc4-b77c6dc385f9/start")}).then().never(new Condition[]{Condition.method((Method)Method.GET), Condition.uri((String)"/deployit/task/7717458d-ede4-4112-bdc4-b77c6dc385f9")}).then().never(new Condition[]{Condition.method((Method)Method.POST), Condition.uri((String)"/deployit/task/7717458d-ede4-4112-bdc4-b77c6dc385f9/archive")});
    }

    @Test(expected=DeployitException.class)
    public void shouldCancelOnDeploymentErrorByDefault() {
        this.setupDefaultDeployment();
        StubHttp.whenHttp((StubServer)this.stubServer).match(new Condition[]{Condition.get((String)"/deployit/task/7717458d-ede4-4112-bdc4-b77c6dc385f9")}).then(new Action[]{Action.resourceContent((String)"restito/taskinfo_stopped.xml"), this.xmlContentType()});
        StubHttp.whenHttp((StubServer)this.stubServer).match(new Condition[]{Condition.delete((String)"/deployit/task/7717458d-ede4-4112-bdc4-b77c6dc385f9")}).then(new Action[]{Action.status((HttpStatus)HttpStatus.NO_CONTENT_204)});
        try {
            CiDeploy deployer = new CiDeploy(this.communicator);
            DeployOptions options = new DeployOptions("Applications/AnimalZoo-ear/1.0", "Environments/10smallEnv10");
            deployer.deploy(options);
        }
        catch (Throwable throwable) {
            this.verifyStartInitialDeployment().then().once(new Condition[]{Condition.method((Method)Method.POST), Condition.uri((String)"/deployit/deployment")}).then().once(new Condition[]{Condition.method((Method)Method.POST), Condition.uri((String)"/deployit/task/7717458d-ede4-4112-bdc4-b77c6dc385f9/start")}).then().once(new Condition[]{Condition.method((Method)Method.GET), Condition.uri((String)"/deployit/task/7717458d-ede4-4112-bdc4-b77c6dc385f9")}).then().once(new Condition[]{Condition.method((Method)Method.DELETE), Condition.uri((String)"/deployit/task/7717458d-ede4-4112-bdc4-b77c6dc385f9")});
            throw throwable;
        }
        this.verifyStartInitialDeployment().then().once(new Condition[]{Condition.method((Method)Method.POST), Condition.uri((String)"/deployit/deployment")}).then().once(new Condition[]{Condition.method((Method)Method.POST), Condition.uri((String)"/deployit/task/7717458d-ede4-4112-bdc4-b77c6dc385f9/start")}).then().once(new Condition[]{Condition.method((Method)Method.GET), Condition.uri((String)"/deployit/task/7717458d-ede4-4112-bdc4-b77c6dc385f9")}).then().once(new Condition[]{Condition.method((Method)Method.DELETE), Condition.uri((String)"/deployit/task/7717458d-ede4-4112-bdc4-b77c6dc385f9")});
    }

    @Test(expected=DeployitException.class)
    public void shouldCancelWhenDeploymentFails() {
        this.setupDefaultDeployment();
        StubHttp.whenHttp((StubServer)this.stubServer).match(new Condition[]{Condition.get((String)"/deployit/task/7717458d-ede4-4112-bdc4-b77c6dc385f9")}).then(new Action[]{Action.resourceContent((String)"restito/taskinfo_stopped.xml"), this.xmlContentType()});
        StubHttp.whenHttp((StubServer)this.stubServer).match(new Condition[]{Condition.delete((String)"/deployit/task/7717458d-ede4-4112-bdc4-b77c6dc385f9")}).then(new Action[]{Action.status((HttpStatus)HttpStatus.NO_CONTENT_204)});
        try {
            CiDeploy deployer = new CiDeploy(this.communicator);
            DeployOptions options = new DeployOptions("Applications/AnimalZoo-ear/1.0", "Environments/10smallEnv10");
            options.setUpdateDeployeds(true);
            options.setOnFailure(DeployOptions.FailAction.Cancel);
            options.setOrchestrator("default");
            deployer.deploy(options);
        }
        catch (Throwable throwable) {
            this.verifyStartInitialDeployment().then().once(new Condition[]{Condition.method((Method)Method.POST), Condition.uri((String)"/deployit/deployment")}).then().once(new Condition[]{Condition.method((Method)Method.POST), Condition.uri((String)"/deployit/task/7717458d-ede4-4112-bdc4-b77c6dc385f9/start")}).then().once(new Condition[]{Condition.method((Method)Method.GET), Condition.uri((String)"/deployit/task/7717458d-ede4-4112-bdc4-b77c6dc385f9")}).then().once(new Condition[]{Condition.method((Method)Method.DELETE), Condition.uri((String)"/deployit/task/7717458d-ede4-4112-bdc4-b77c6dc385f9")}).then().never(new Condition[]{Condition.method((Method)Method.POST), Condition.uri((String)"/deployit/deployment/rollback/7717458d-ede4-4112-bdc4-b77c6dc385f9")}).then().never(new Condition[]{Condition.method((Method)Method.POST), Condition.uri((String)"/deployit/task/a346597a-c359-53ac-597a-35c76935c941/start")}).then().never(new Condition[]{Condition.method((Method)Method.GET), Condition.uri((String)"/deployit/task/a346597a-c359-53ac-597a-35c76935c941")}).then().never(new Condition[]{Condition.method((Method)Method.POST), Condition.uri((String)"/deployit/task/a346597a-c359-53ac-597a-35c76935c941/archive")});
            throw throwable;
        }
        this.verifyStartInitialDeployment().then().once(new Condition[]{Condition.method((Method)Method.POST), Condition.uri((String)"/deployit/deployment")}).then().once(new Condition[]{Condition.method((Method)Method.POST), Condition.uri((String)"/deployit/task/7717458d-ede4-4112-bdc4-b77c6dc385f9/start")}).then().once(new Condition[]{Condition.method((Method)Method.GET), Condition.uri((String)"/deployit/task/7717458d-ede4-4112-bdc4-b77c6dc385f9")}).then().once(new Condition[]{Condition.method((Method)Method.DELETE), Condition.uri((String)"/deployit/task/7717458d-ede4-4112-bdc4-b77c6dc385f9")}).then().never(new Condition[]{Condition.method((Method)Method.POST), Condition.uri((String)"/deployit/deployment/rollback/7717458d-ede4-4112-bdc4-b77c6dc385f9")}).then().never(new Condition[]{Condition.method((Method)Method.POST), Condition.uri((String)"/deployit/task/a346597a-c359-53ac-597a-35c76935c941/start")}).then().never(new Condition[]{Condition.method((Method)Method.GET), Condition.uri((String)"/deployit/task/a346597a-c359-53ac-597a-35c76935c941")}).then().never(new Condition[]{Condition.method((Method)Method.POST), Condition.uri((String)"/deployit/task/a346597a-c359-53ac-597a-35c76935c941/archive")});
    }

    @Test(expected=DeployitException.class)
    public void shouldDoNothingWhenDeploymentFails() {
        this.setupDefaultDeployment();
        StubHttp.whenHttp((StubServer)this.stubServer).match(new Condition[]{Condition.get((String)"/deployit/task/7717458d-ede4-4112-bdc4-b77c6dc385f9")}).then(new Action[]{Action.resourceContent((String)"restito/taskinfo_stopped.xml"), this.xmlContentType()});
        StubHttp.whenHttp((StubServer)this.stubServer).match(new Condition[]{Condition.delete((String)"/deployit/task/7717458d-ede4-4112-bdc4-b77c6dc385f9")}).then(new Action[]{Action.status((HttpStatus)HttpStatus.NO_CONTENT_204)});
        try {
            CiDeploy deployer = new CiDeploy(this.communicator);
            DeployOptions options = new DeployOptions("Applications/AnimalZoo-ear/1.0", "Environments/10smallEnv10");
            options.setUpdateDeployeds(true);
            options.setOnFailure(DeployOptions.FailAction.Nothing);
            options.setOrchestrator("default,container-by-container");
            deployer.deploy(options);
        }
        catch (Throwable throwable) {
            this.verifyStartInitialDeployment().then().once(new Condition[]{Condition.method((Method)Method.POST), Condition.uri((String)"/deployit/deployment")}).then().once(new Condition[]{Condition.method((Method)Method.POST), Condition.uri((String)"/deployit/task/7717458d-ede4-4112-bdc4-b77c6dc385f9/start")}).then().once(new Condition[]{Condition.method((Method)Method.GET), Condition.uri((String)"/deployit/task/7717458d-ede4-4112-bdc4-b77c6dc385f9")}).then().never(new Condition[]{Condition.method((Method)Method.DELETE), Condition.uri((String)"/deployit/task/7717458d-ede4-4112-bdc4-b77c6dc385f9")}).then().never(new Condition[]{Condition.method((Method)Method.POST), Condition.uri((String)"/deployit/deployment/rollback/7717458d-ede4-4112-bdc4-b77c6dc385f9")}).then().never(new Condition[]{Condition.method((Method)Method.POST), Condition.uri((String)"/deployit/task/a346597a-c359-53ac-597a-35c76935c941/start")}).then().never(new Condition[]{Condition.method((Method)Method.GET), Condition.uri((String)"/deployit/task/a346597a-c359-53ac-597a-35c76935c941")}).then().never(new Condition[]{Condition.method((Method)Method.POST), Condition.uri((String)"/deployit/task/a346597a-c359-53ac-597a-35c76935c941/archive")});
            throw throwable;
        }
        this.verifyStartInitialDeployment().then().once(new Condition[]{Condition.method((Method)Method.POST), Condition.uri((String)"/deployit/deployment")}).then().once(new Condition[]{Condition.method((Method)Method.POST), Condition.uri((String)"/deployit/task/7717458d-ede4-4112-bdc4-b77c6dc385f9/start")}).then().once(new Condition[]{Condition.method((Method)Method.GET), Condition.uri((String)"/deployit/task/7717458d-ede4-4112-bdc4-b77c6dc385f9")}).then().never(new Condition[]{Condition.method((Method)Method.DELETE), Condition.uri((String)"/deployit/task/7717458d-ede4-4112-bdc4-b77c6dc385f9")}).then().never(new Condition[]{Condition.method((Method)Method.POST), Condition.uri((String)"/deployit/deployment/rollback/7717458d-ede4-4112-bdc4-b77c6dc385f9")}).then().never(new Condition[]{Condition.method((Method)Method.POST), Condition.uri((String)"/deployit/task/a346597a-c359-53ac-597a-35c76935c941/start")}).then().never(new Condition[]{Condition.method((Method)Method.GET), Condition.uri((String)"/deployit/task/a346597a-c359-53ac-597a-35c76935c941")}).then().never(new Condition[]{Condition.method((Method)Method.POST), Condition.uri((String)"/deployit/task/a346597a-c359-53ac-597a-35c76935c941/archive")});
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionOnWrongApplicationId() {
        CiDeploy deployer = new CiDeploy(this.communicator);
        deployer.getDeployedApplicationId("Applications/myApp", "Environments/myEnv");
    }

    @Test
    public void shouldReturnDeployedApplicationId() {
        CiDeploy deployer = new CiDeploy(this.communicator);
        String applicationId = deployer.getDeployedApplicationId("Applications/myApp/1.0", "Environments/myEnv");
        Assert.assertThat((Object)applicationId, (Matcher)IsEqual.equalTo((Object)"Environments/myEnv/myApp"));
    }

    private VerifySequenced verifyStartInitialDeployment() {
        return VerifyHttp.verifyHttp((StubServer)this.stubServer).once(new Condition[]{Condition.method((Method)Method.GET), Condition.uri((String)"/deployit/repository/exists/Environments/10smallEnv10/AnimalZoo-ear")}).then().once(new Condition[]{Condition.method((Method)Method.GET), Condition.uri((String)"/deployit/deployment/prepare/initial"), Condition.parameter((String)"environment", (String[])new String[]{"Environments/10smallEnv10"}), Condition.parameter((String)"version", (String[])new String[]{"Applications/AnimalZoo-ear/1.0"})}).then().once(new Condition[]{Condition.method((Method)Method.POST), Condition.uri((String)"/deployit/deployment/prepare/deployeds")}).then().once(new Condition[]{Condition.method((Method)Method.POST), Condition.uri((String)"/deployit/deployment/validate")});
    }

    private void setupDefaultDeployment() {
        StubHttp.whenHttp((StubServer)this.stubServer).match(new Condition[]{Condition.get((String)"/deployit/repository/exists/Environments/10smallEnv10/AnimalZoo-ear")}).then(new Action[]{Action.stringContent((String)"<boolean>false</boolean>"), this.xmlContentType()});
        StubHttp.whenHttp((StubServer)this.stubServer).match(new Condition[]{Condition.post((String)"/deployit/deployment/prepare/deployeds")}).then(new Action[]{Action.resourceContent((String)"restito/deployit_deployment_prepare_initial.xml"), this.xmlContentType()});
        StubHttp.whenHttp((StubServer)this.stubServer).match(new Condition[]{Condition.get((String)"/deployit/deployment/prepare/initial"), Condition.parameter((String)"environment", (String[])new String[]{"Environments/10smallEnv10"}), Condition.parameter((String)"version", (String[])new String[]{"Applications/AnimalZoo-ear/1.0"})}).then(new Action[]{Action.resourceContent((String)"restito/deployit_deployment_prepare_initial.xml"), this.xmlContentType()});
        StubHttp.whenHttp((StubServer)this.stubServer).match(new Condition[]{Condition.post((String)"/deployit/deployment/generate/all")}).then(new Action[]{Action.resourceContent((String)"restito/deployit_deployment_generate_all.xml"), this.xmlContentType()});
        StubHttp.whenHttp((StubServer)this.stubServer).match(new Condition[]{Condition.post((String)"/deployit/deployment/validate")}).then(new Action[]{Action.resourceContent((String)"restito/deployment_validate.xml"), this.xmlContentType()});
        StubHttp.whenHttp((StubServer)this.stubServer).match(new Condition[]{Condition.post((String)"/deployit/deployment")}).then(new Action[]{Action.resourceContent((String)"restito/deployit_deployment.xml"), this.xmlContentType()});
        StubHttp.whenHttp((StubServer)this.stubServer).match(new Condition[]{Condition.post((String)"/deployit/task/7717458d-ede4-4112-bdc4-b77c6dc385f9/start")}).then(new Action[]{Action.status((HttpStatus)HttpStatus.NO_CONTENT_204)});
        StubHttp.whenHttp((StubServer)this.stubServer).match(new Condition[]{Condition.get((String)"/deployit/task/7717458d-ede4-4112-bdc4-b77c6dc385f9")}).then(new Action[]{Action.resourceContent((String)"restito/taskinfo_pending.xml"), this.xmlContentType()});
        StubHttp.whenHttp((StubServer)this.stubServer).match(new Condition[]{Condition.get((String)"/deployit/task/7717458d-ede4-4112-bdc4-b77c6dc385f9/step/1")}).then(new Action[]{Action.resourceContent((String)"restito/task_step.xml"), this.xmlContentType()});
        StubHttp.whenHttp((StubServer)this.stubServer).match(new Condition[]{Condition.post((String)"/deployit/task/7717458d-ede4-4112-bdc4-b77c6dc385f9/archive")}).then(new Action[]{Action.status((HttpStatus)HttpStatus.NO_CONTENT_204)});
    }

    private Action xmlContentType() {
        return Action.contentType((String)"application/xml");
    }
}

