/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.ci.bamboo.tasks;

import com.atlassian.bamboo.build.BuildDefinition;
import com.atlassian.bamboo.build.BuildDefinitionManager;
import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.deployments.environments.Environment;
import com.atlassian.bamboo.deployments.environments.service.EnvironmentService;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.task.TaskConfiguratorHelper;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.TaskPredicates;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.v2.build.agent.capability.Requirement;
import com.atlassian.bamboo.v2.build.agent.capability.RequirementImpl;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.opensymphony.xwork2.TextProvider;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BambooTaskConfigurationHelper
implements TaskConfiguratorHelper {
    private final BuildDefinitionManager buildDefinitionManager;
    private final EnvironmentService environmentService;
    private final TextProvider textProvider;

    public BambooTaskConfigurationHelper(BuildDefinitionManager buildDefinitionManager, EnvironmentService environmentService, TextProvider textProvider) {
        this.buildDefinitionManager = buildDefinitionManager;
        this.environmentService = environmentService;
        this.textProvider = textProvider;
    }

    public void populateContextWithConfiguration(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition, @NotNull Iterable<String> keys) {
        for (String key : keys) {
            context.put(key, taskDefinition.getConfiguration().get(key));
        }
    }

    public void populateTaskConfigMapWithActionParameters(@NotNull Map<String, String> config, @NotNull ActionParametersMap params, @NotNull Iterable<String> keys) {
        for (String key : keys) {
            config.put(key, params.getString(key));
        }
    }

    public void addJdkRequirement(@NotNull Set<Requirement> requirements, @NotNull TaskDefinition taskDefinition, @NotNull String cfgJdkLabel) {
        this.addSystemRequirementFromConfiguration(requirements, taskDefinition, cfgJdkLabel, "system.jdk");
    }

    public void addSystemRequirementFromConfiguration(@NotNull Set<Requirement> requirements, @NotNull TaskDefinition taskDefinition, @NotNull String cfgKey, @NotNull String requirementPrefix) {
        String builderLabel = (String)taskDefinition.getConfiguration().get(cfgKey);
        if (builderLabel != null) {
            requirements.add((Requirement)new RequirementImpl(requirementPrefix + "." + builderLabel, true, ".*"));
        }
    }

    @Nullable
    public Requirement createRequirementFromConfiguration(@NotNull TaskDefinition taskDefinition, @NotNull String cfgKey) {
        String capability = (String)taskDefinition.getConfiguration().get(cfgKey);
        return capability == null ? null : new RequirementImpl(capability, true, ".*");
    }

    public void validateJdk(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        if (StringUtils.isEmpty((CharSequence)params.getString("buildJdk"))) {
            errorCollection.addError("buildJdk", this.textProvider.getText("task.generic.validate.jdkLabel.mandatory"));
        }
    }

    public void validateBuilderLabel(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        if (StringUtils.isEmpty((CharSequence)params.getString("label"))) {
            errorCollection.addError("label", this.textProvider.getText("task.generic.validate.builderLabel.mandatory"));
        }
    }

    public void validateTestResultsFilePattern(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        if (params.getBoolean("testChecked") && StringUtils.isEmpty((CharSequence)params.getString("testResultsDirectory"))) {
            errorCollection.addError("testResultsDirectory", this.textProvider.getText("task.generic.validate.testResultsPattern.mandatory"));
        }
    }

    public void validateTestResultsFilePatternIfCustomPatternSelected(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection, @NotNull String cfgTestResultsFilePatternOptionCustom) {
        if (params.getBoolean("testChecked") && cfgTestResultsFilePatternOptionCustom.equals(params.getString("testDirectoryOption")) && StringUtils.isEmpty((CharSequence)params.getString("testResultsDirectory"))) {
            errorCollection.addError("testResultsDirectory", this.textProvider.getText("task.generic.validate.testResultsPattern.mandatory"));
        }
    }

    @NotNull
    public Optional<TaskDefinition> getTaskDefinition(@NotNull ActionParametersMap params) {
        long taskId = params.getLong("taskId", -1L);
        if (taskId == -1L) {
            return Optional.empty();
        }
        List<TaskDefinition> taskDefinitions = this.getTaskDefinitions(params);
        Stream var10000 = taskDefinitions.stream();
        Predicate var10001 = TaskPredicates.hasTaskDefinitionEqualId((long)taskId);
        var10001.getClass();
        return var10000.filter(arg_0 -> ((Predicate)var10001).apply(arg_0)).findFirst();
    }

    @NotNull
    public Optional<TaskDefinition> extractTaskDefinition(@NotNull ActionParametersMap params) {
        long taskId = params.getLong("taskId", -1L);
        if (taskId == -1L) {
            return Optional.empty();
        }
        Stream var10000 = this.getTaskDefinitions(params).stream();
        Predicate var10001 = TaskPredicates.hasTaskDefinitionEqualId((long)taskId);
        var10001.getClass();
        return var10000.filter(arg_0 -> ((Predicate)var10001).apply(arg_0)).findAny();
    }

    @NotNull
    public List<TaskDefinition> getTaskDefinitions(ActionParametersMap params) {
        List taskDefinitions;
        if (params.containsKey((Object)"planKey") && params.containsKey((Object)"environmentId")) {
            throw new IllegalArgumentException("ActionParametersMap contains conflicting parameters.");
        }
        if (params.containsKey((Object)"planKey")) {
            PlanKey jobKey = PlanKeys.getPlanKey((String)params.getString("planKey"));
            BuildDefinition buildDefinition = this.buildDefinitionManager.getBuildDefinition(jobKey);
            taskDefinitions = buildDefinition.getTaskDefinitions();
        } else {
            if (!params.containsKey((Object)"environmentId")) {
                throw new IllegalArgumentException("ActionParametersMap does not represent a build or deployment task");
            }
            long environmentId = params.getLong("environmentId", -1L);
            Environment environment = this.environmentService.getEnvironment(environmentId);
            Preconditions.checkNotNull((Object)environment, (Object)("Environment in action params not found, environmentId: " + environmentId));
            taskDefinitions = environment.getTaskDefinitions();
        }
        return taskDefinitions;
    }
}

