/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.ci.bamboo.tasks;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.configuration.ConfigurationMap;
import com.atlassian.bamboo.logger.ErrorUpdateHandler;
import com.atlassian.bamboo.task.TaskContext;
import com.xebialabs.deployit.ci.bamboo.tasks.AbstractDeployitTask;
import com.xebialabs.deployit.client.DeployitCli;
import com.xebialabs.deployit.client.DeploymentOptions;
import java.util.Collections;

public class DeployApplicationTaskAbstract
extends AbstractDeployitTask {
    public DeployApplicationTaskAbstract(ErrorUpdateHandler errorUpdateHandler) {
        super(errorUpdateHandler);
    }

    @Override
    void doExecute(TaskContext taskContext, DeployitCli cli) {
        ConfigurationMap configurationMap = taskContext.getConfigurationMap();
        BuildLogger buildLogger = taskContext.getBuildLogger();
        String environmentName = (String)configurationMap.get((Object)"deployitEnvironment");
        String applicationName = (String)configurationMap.get((Object)"deployitApplication");
        if (configurationMap.getAsBoolean("deployitLastestVersion")) {
            throw new UnsupportedOperationException("LatestImported Option not yet implemented");
        }
        String version = (String)configurationMap.get((Object)"deployitVersion");
        String deploymentPackage = String.format("Applications/%s/%s", applicationName, version);
        String environment = String.format("Environments/%s", environmentName);
        buildLogger.addBuildLogEntry(String.format("Deploying '%s' to environment '%s'", deploymentPackage, environment));
        cli.deploy(deploymentPackage, environment, Collections.emptyList(), this.getDeploymentOptions(configurationMap), cli.getListener());
        buildLogger.addBuildLogEntry("Application was successfully deployed.");
    }

    protected DeploymentOptions getDeploymentOptions(ConfigurationMap configurationMap) {
        boolean skipMode = configurationMap.getAsBoolean("deployitSkipSteps");
        boolean testMode = configurationMap.getAsBoolean("deployitTestMode");
        return new DeploymentOptions(skipMode, testMode, false, false, false, false, true, true, "");
    }
}

