/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.ascode.service;

import com.xebialabs.ascode.exception.AsCodeException;
import com.xebialabs.ascode.exception.AsCodeException$;
import com.xebialabs.ascode.yaml.dto.PreviewResponse;
import com.xebialabs.ascode.yaml.model.Definition;
import com.xebialabs.deployit.ascode.service.spec.util.DeploymentPreparationService;
import com.xebialabs.deployit.ascode.yaml.model.Constants$Kinds$;
import com.xebialabs.deployit.ascode.yaml.model.DeploymentSpec;
import com.xebialabs.deployit.engine.api.DeploymentService;
import com.xebialabs.deployit.engine.api.dto.Deployment;
import com.xebialabs.deployit.engine.api.execution.BlockState;
import com.xebialabs.deployit.engine.api.execution.StepBlockState;
import com.xebialabs.deployit.engine.api.execution.StepState;
import com.xebialabs.deployit.engine.api.execution.TaskPreviewBlock;
import com.xebialabs.deployit.engine.tasker.Block;
import com.xebialabs.deployit.engine.tasker.ParallelBlock;
import com.xebialabs.deployit.engine.tasker.Phase;
import com.xebialabs.deployit.engine.tasker.PhaseContainer;
import com.xebialabs.deployit.engine.tasker.SerialBlock;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.convert.ImplicitConversions$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Service
@Autowired
@ScalaSignature(bytes="\u0006\u0001\u0005ec\u0001B\u0005\u000b\u0001UA\u0001\u0002\b\u0001\u0003\u0002\u0003\u0006I!\b\u0005\tK\u0001\u0011\t\u0011)A\u0005M!)a\u0006\u0001C\u0001_!)A\u0007\u0001C\u0005k!)q\u000b\u0001C\u00051\"9A\u000eAI\u0001\n\u0013i\u0007\"\u0002=\u0001\t\u0013I\bbBA\n\u0001\u0011\u0005\u0011Q\u0003\u0002\u000f!J,g/[3x'\u0016\u0014h/[2f\u0015\tYA\"A\u0004tKJ4\u0018nY3\u000b\u00055q\u0011AB1tG>$WM\u0003\u0002\u0010!\u0005AA-\u001a9m_fLGO\u0003\u0002\u0012%\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002'\u0005\u00191m\\7\u0004\u0001M\u0011\u0001A\u0006\t\u0003/ii\u0011\u0001\u0007\u0006\u00023\u0005)1oY1mC&\u00111\u0004\u0007\u0002\u0007\u0003:L(+\u001a4\u0002#\u0011,\u0007\u000f\\8z[\u0016tGoU3sm&\u001cW\r\u0005\u0002\u001fG5\tqD\u0003\u0002!C\u0005\u0019\u0011\r]5\u000b\u0005\tr\u0011AB3oO&tW-\u0003\u0002%?\t\tB)\u001a9m_flWM\u001c;TKJ4\u0018nY3\u00029\u0011,\u0007\u000f\\8z[\u0016tG\u000f\u0015:fa\u0006\u0014\u0018\r^5p]N+'O^5dKB\u0011q\u0005L\u0007\u0002Q)\u0011\u0011FK\u0001\u0005kRLGN\u0003\u0002,\u0015\u0005!1\u000f]3d\u0013\ti\u0003F\u0001\u000fEKBdw._7f]R\u0004&/\u001a9be\u0006$\u0018n\u001c8TKJ4\u0018nY3\u0002\rqJg.\u001b;?)\r\u0001$g\r\t\u0003c\u0001i\u0011A\u0003\u0005\u00069\r\u0001\r!\b\u0005\u0006K\r\u0001\rAJ\u0001\u0013iJ\fgn\u001d4pe6\u001cF/\u001a9Ti\u0006$X\r\u0006\u00027\u001fB\u0011q\u0007\u0014\b\u0003q%s!!\u000f$\u000f\u0005i\u001aeBA\u001eC\u001d\ta\u0014I\u0004\u0002>\u00016\taH\u0003\u0002@)\u00051AH]8pizJ\u0011aE\u0005\u0003#II!!\u0004\t\n\u0005\u0011+\u0015\u0001B=b[2T!!\u0004\t\n\u0005\u001dC\u0015a\u00013u_*\u0011A)R\u0005\u0003\u0015.\u000bq\u0002\u0015:fm&,wOU3ta>t7/\u001a\u0006\u0003\u000f\"K!!\u0014(\u0003\u001fQ\u000b7o\u001b)sKZLWm^%uK6T!AS&\t\u000bA#\u0001\u0019A)\u0002\u0013M$X\r]*uCR,\u0007C\u0001*V\u001b\u0005\u0019&B\u0001+ \u0003%)\u00070Z2vi&|g.\u0003\u0002W'\nI1\u000b^3q'R\fG/Z\u0001\u0014iJ\fgn\u001d4pe6\u0014En\\2l'R\fG/\u001a\u000b\u00043\n<\u0007c\u0001.`m9\u00111,\u0018\b\u0003{qK\u0011!G\u0005\u0003=b\tq\u0001]1dW\u0006<W-\u0003\u0002aC\n!A*[:u\u0015\tq\u0006\u0004C\u0003d\u000b\u0001\u0007A-\u0001\u0006cY>\u001c7n\u0015;bi\u0016\u0004\"AU3\n\u0005\u0019\u001c&A\u0003\"m_\u000e\\7\u000b^1uK\"9\u0001.\u0002I\u0001\u0002\u0004I\u0017AC5t!\u0006\u0014\u0018\r\u001c7fYB\u0011qC[\u0005\u0003Wb\u0011qAQ8pY\u0016\fg.A\u000fue\u0006t7OZ8s[\ncwnY6Ti\u0006$X\r\n3fM\u0006,H\u000e\u001e\u00133+\u0005q'FA5pW\u0005\u0001\bCA9w\u001b\u0005\u0011(BA:u\u0003%)hn\u00195fG.,GM\u0003\u0002v1\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005]\u0014(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006\u0011r-\u001a;UCN\\G)Z:de&\u0004H/[8o)\rQ\u0018Q\u0001\t\u0003w~t!\u0001`?\u0011\u0005uB\u0012B\u0001@\u0019\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011AA\u0002\u0005\u0019\u0019FO]5oO*\u0011a\u0010\u0007\u0005\b\u0003\u000f9\u0001\u0019AA\u0005\u0003)!W\r\u001d7ps6,g\u000e\u001e\t\u0005\u0003\u0017\ty!\u0004\u0002\u0002\u000e)\u0011qiH\u0005\u0005\u0003#\tiA\u0001\u0006EKBdw._7f]R\fq\u0001\u001d:fm&,w\u000f\u0006\u0003\u0002\u0018\u0005}\u0001\u0003BA\r\u00037i\u0011aS\u0005\u0004\u0003;Y%a\u0004)sKZLWm\u001e*fgB|gn]3\t\u000f\u0005\u0005\u0002\u00021\u0001\u0002$\u0005QA-\u001a4j]&$\u0018n\u001c8\u0011\t\u0005\u0015\u00121F\u0007\u0003\u0003OQ1!!\u000bI\u0003\u0015iw\u000eZ3m\u0013\u0011\ti#a\n\u0003\u0015\u0011+g-\u001b8ji&|g\u000eK\u0002\u0001\u0003c\u0001B!a\r\u0002H5\u0011\u0011Q\u0007\u0006\u0004k\u0006]\"\u0002BA\u001d\u0003w\tqAZ1di>\u0014\u0018P\u0003\u0003\u0002>\u0005}\u0012!\u00022fC:\u001c(\u0002BA!\u0003\u0007\nqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0003\u0003\u000b\n1a\u001c:h\u0013\u0011\tI%!\u000e\u0003\u0013\u0005+Ho\\<je\u0016$\u0007f\u0001\u0001\u0002NA!\u0011qJA+\u001b\t\t\tF\u0003\u0003\u0002T\u0005}\u0012AC:uKJ,w\u000e^=qK&!\u0011qKA)\u0005\u001d\u0019VM\u001d<jG\u0016\u0004")
public class PreviewService {
    private final DeploymentService deploymentService;
    private final DeploymentPreparationService deploymentPreparationService;

    private PreviewResponse.TaskPreviewItem transformStepState(StepState stepState) {
        return new PreviewResponse.TaskPreviewItem(stepState.getDescription(), (List)Nil$.MODULE$, PreviewResponse.TaskPreviewItem$.MODULE$.apply$default$3());
    }

    private List<PreviewResponse.TaskPreviewItem> transformBlockState(BlockState blockState, boolean isParallel) {
        Nil$ nil$;
        block7: {
            BlockState blockState2;
            while (true) {
                if ((blockState2 = blockState) instanceof PhaseContainer) {
                    PhaseContainer phaseContainer = (PhaseContainer)blockState2;
                    List children = (List)phaseContainer.phases().toList().flatMap((Function1 & Serializable & scala.Serializable)x$1 -> this.transformBlockState((BlockState)x$1, this.transformBlockState$default$2()), List$.MODULE$.canBuildFrom());
                    nil$ = (List)Option$.MODULE$.apply((Object)phaseContainer.description()).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)PreviewService.$anonfun$transformBlockState$2(x$2))).map((Function1 & Serializable & scala.Serializable)desc -> {
                        PreviewResponse.TaskPreviewItem taskPreviewItem = new PreviewResponse.TaskPreviewItem(desc, children, isParallel);
                        return Nil$.MODULE$.$colon$colon((Object)taskPreviewItem);
                    }).getOrElse((Function0 & Serializable & scala.Serializable)() -> children);
                    break block7;
                }
                if (blockState2 instanceof ParallelBlock) {
                    ParallelBlock parallelBlock = (ParallelBlock)blockState2;
                    String description = parallelBlock.description();
                    Seq blocks = parallelBlock.blocks();
                    PreviewResponse.TaskPreviewItem taskPreviewItem = new PreviewResponse.TaskPreviewItem(description, (List)blocks.toList().flatMap((Function1 & Serializable & scala.Serializable)x$4 -> this.transformBlockState((BlockState)x$4, true), List$.MODULE$.canBuildFrom()), isParallel);
                    nil$ = Nil$.MODULE$.$colon$colon((Object)taskPreviewItem);
                    break block7;
                }
                if (blockState2 instanceof SerialBlock) {
                    SerialBlock serialBlock = (SerialBlock)blockState2;
                    String description = serialBlock.description();
                    Seq blocks = serialBlock.blocks();
                    PreviewResponse.TaskPreviewItem taskPreviewItem = new PreviewResponse.TaskPreviewItem(description, (List)blocks.toList().flatMap((Function1 & Serializable & scala.Serializable)x$6 -> this.transformBlockState((BlockState)x$6, this.transformBlockState$default$2()), List$.MODULE$.canBuildFrom()), isParallel);
                    nil$ = Nil$.MODULE$.$colon$colon((Object)taskPreviewItem);
                    break block7;
                }
                if (blockState2 instanceof StepBlockState) {
                    StepBlockState stepBlockState = (StepBlockState)blockState2;
                    PreviewResponse.TaskPreviewItem taskPreviewItem = new PreviewResponse.TaskPreviewItem(stepBlockState.getDescription(), (List)ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(stepBlockState.getSteps()).toList().map((Function1 & Serializable & scala.Serializable)stepState -> this.transformStepState((StepState)stepState), List$.MODULE$.canBuildFrom()), isParallel);
                    nil$ = Nil$.MODULE$.$colon$colon((Object)taskPreviewItem);
                    break block7;
                }
                if (!(blockState2 instanceof Phase)) break;
                Phase phase = (Phase)blockState2;
                isParallel = this.transformBlockState$default$2();
                blockState = phase.block();
            }
            if (blockState2 instanceof Block) {
                Block block = (Block)blockState2;
                PreviewResponse.TaskPreviewItem taskPreviewItem = new PreviewResponse.TaskPreviewItem(block.description(), (List)ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(block.getStepList()).toList().map((Function1 & Serializable & scala.Serializable)stepState -> this.transformStepState((StepState)stepState), List$.MODULE$.canBuildFrom()), isParallel);
                nil$ = Nil$.MODULE$.$colon$colon((Object)taskPreviewItem);
            } else {
                nil$ = Nil$.MODULE$;
            }
        }
        return nil$;
    }

    private boolean transformBlockState$default$2() {
        return false;
    }

    private String getTaskDescription(Deployment deployment) {
        String string;
        Deployment.DeploymentType deploymentType = deployment.getDeploymentType();
        if (Deployment.DeploymentType.INITIAL.equals(deploymentType)) {
            string = "deployed to";
        } else if (Deployment.DeploymentType.UPDATE.equals(deploymentType)) {
            string = "updated on";
        } else if (Deployment.DeploymentType.UNDEPLOYMENT.equals(deploymentType)) {
            string = "un-deployed from";
        } else {
            throw new MatchError((Object)deploymentType);
        }
        String typeRelatedPart = string;
        ConfigurationItem configurationItem = deployment.getDeployedApplication();
        if (!(configurationItem instanceof DeployedApplication)) {
            throw new MatchError((Object)configurationItem);
        }
        DeployedApplication deployedApplication = (DeployedApplication)configurationItem;
        String string2 = new StringBuilder(26).append("Application '").append(deployedApplication.getVersion().getId()).append("' will be ").append(typeRelatedPart).append(" '").append(deployedApplication.getEnvironment().getId()).append("'").toString();
        return string2;
    }

    public PreviewResponse preview(Definition definition) {
        String string = definition.kind();
        String string2 = Constants$Kinds$.MODULE$.DEPLOYMENT();
        if (string == null ? string2 != null : !string.equals(string2)) {
            throw new AsCodeException(new StringBuilder(54).append("Cannot preview '").append(definition.kind()).append("' spec. Only '").append(Constants$Kinds$.MODULE$.DEPLOYMENT()).append("' spec kind is supported").toString(), AsCodeException$.MODULE$.$lessinit$greater$default$2());
        }
        DeploymentSpec spec = (DeploymentSpec)definition.spec();
        Deployment deployment = this.deploymentPreparationService.deploymentSpecToDeployment(spec);
        TaskPreviewBlock taskPreviewBlock = this.deploymentService.taskPreviewBlock(deployment);
        List<PreviewResponse.TaskPreviewItem> taskPreviewItems = this.transformBlockState(taskPreviewBlock.getBlock(), this.transformBlockState$default$2());
        return new PreviewResponse((Option)new Some((Object)new PreviewResponse.TaskInfo(this.getTaskDescription(deployment), taskPreviewItems)));
    }

    public static final /* synthetic */ boolean $anonfun$transformBlockState$2(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).nonEmpty();
    }

    public PreviewService(DeploymentService deploymentService, DeploymentPreparationService deploymentPreparationService) {
        this.deploymentService = deploymentService;
        this.deploymentPreparationService = deploymentPreparationService;
    }
}

