package com.xebialabs.deployit.ascode.yaml.parser.spec.ci

import com.fasterxml.jackson.databind.{JsonNode, ObjectMapper}
import com.xebialabs.ascode.yaml.model.{CiSpec, Spec}
import com.xebialabs.ascode.yaml.parser.SpecParser
import com.xebialabs.ascode.yaml.parser.support.{JacksonCiListReader, ReaderConfig}
import com.xebialabs.ascode.yaml.sugar.DeSugarProcessor.desugarSpec
import com.xebialabs.ascode.yaml.sugar.SugarConfig
import com.xebialabs.deployit.ascode.yaml.parser.util.{CiSpecNodeValidator, RelativeIdResolver}

import scala.jdk.CollectionConverters._

class CiSpecParser(implicit sugarConfig: SugarConfig) extends SpecParser  {
  private def createReaderConfig(definitionKind: String,
                                 metadata: Option[Map[String, String]]) = ReaderConfig(
    overrides = Map("name" -> "id"),
    reserved = Set("id", "name", "type"),
    idResolver = new RelativeIdResolver(definitionKind, metadata),
    nodeValidator = CiSpecNodeValidator
  )

  override def parse(definitionKind: String,
                     metadata: Option[Map[String, String]],
                     node: JsonNode)(implicit mapper: ObjectMapper): Spec = {
    val desugaredNode = desugarSpec(node)
    val config = createReaderConfig(definitionKind, metadata)
    val reader = new JacksonCiListReader(desugaredNode, None, config)
    val converter = new ConfigurationItemParser()
    converter.readCis(reader)
    val cis = converter.getReadCIs.values().asScala.toList
    CiSpec(cis, converter.getReferences.asScala.toList, converter.foundFiles)
  }
}
