package com.xebialabs.deployit.ascode.yaml.parser.spec.deployment

import com.fasterxml.jackson.databind.{JsonNode, ObjectMapper}
import com.xebialabs.ascode.utils.TypeSugar._
import com.xebialabs.ascode.yaml.model.Spec
import com.xebialabs.ascode.yaml.parser.SpecParser
import com.xebialabs.ascode.yaml.parser.support.{JacksonCiReader, ReaderConfig}
import com.xebialabs.ascode.yaml.parser.util.JsonNodeSugar._
import com.xebialabs.deployit.ascode.yaml.model.Constants.Kinds.STITCH_DRYRUN
import com.xebialabs.deployit.ascode.yaml.model.DeploymentSpec
import com.xebialabs.deployit.ascode.yaml.parser.util.RelativeIdResolver
import com.xebialabs.deployit.core.xml.PasswordEncryptingCiConverter
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication

import scala.jdk.CollectionConverters._

object DeploymentSpecParser extends SpecParser {
  private val definitionKey = "deploymentKindSpec"
  private val reservedProperties = Set("package", "environment", "id", "type", "stitchSource",
    "branchName", "deploymentType")
  private val overrides = Map("orchestrators" -> "orchestrator", "package" -> "version")

  override def parse(definitionKind: String,
                     metadata: Option[Map[String, String]],
                     node: JsonNode)(implicit mapper: ObjectMapper): Spec = {
    val config = ReaderConfig(
      overrides = overrides,
      reserved = reservedProperties,
      idResolver = new RelativeIdResolver(definitionKind, metadata)
    )
    val reader = new JacksonCiReader(node, None, config) {
      override def getType: String = typeOf[DeployedApplication].toString
    }
    val converter = new PasswordEncryptingCiConverter()
    val deploymentType = node.string("deploymentType")
    val version = node.requiredString("package")
    val environment = deploymentType match {
      case Some(deploymentType) if !deploymentType.equalsIgnoreCase("UnDeployment") =>
        node.requiredString("environment")
      case None => node.requiredString("environment")
      case _ => null
    }
    val deploymentSpec = converter.readCi(reader).asInstanceOf[DeployedApplication]


    if (definitionKind == STITCH_DRYRUN) {
      val stitchSource = node.requiredString("stitchSource")
      val branchName = node.requiredString("branchName")
      DeploymentSpec(version, environment, deploymentSpec, converter.getReferences.asScala.toList, stitchSource,
        branchName, deploymentType.getOrElse(""))
    } else {
      DeploymentSpec(version, environment, deploymentSpec, converter.getReferences.asScala.toList, null, null,
        deploymentType.getOrElse(""))
    }
  }
}
