package com.xebialabs.deployit.ascode.yaml.writer

import com.fasterxml.jackson.databind.ObjectMapper
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator
import com.xebialabs.ascode.yaml.model.Spec
import com.xebialabs.ascode.yaml.writer.DefinitionWriter.WriterConfig
import com.xebialabs.ascode.yaml.writer.{GenerateContext, SpecWriter, UsersWriter}
import com.xebialabs.deployit.ascode.yaml.model.user.XLDUser

object XLDUsersWriter extends SpecWriter {
  private val writer = new UsersWriter[XLDUser]({ case (user, generator) =>
    user.name.foreach(generator.writeStringField("name", _))
    user.email.foreach(generator.writeStringField("email", _))
    generator.writeBooleanField("enabled", user.enabled)
  })

  override def write(spec: Spec, yamlGenerator: YAMLGenerator)(implicit mapper: ObjectMapper, config: WriterConfig): GenerateContext =
    writer.write(spec, yamlGenerator)
}
