/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.ascode.service;

import com.xebialabs.ascode.exception.AsCodeException;
import com.xebialabs.ascode.exception.AsCodeException$;
import com.xebialabs.ascode.yaml.dto.PreviewResponse;
import com.xebialabs.ascode.yaml.model.Definition;
import com.xebialabs.deployit.ascode.service.StitchPreviewService;
import com.xebialabs.deployit.ascode.service.spec.util.DeploymentPreparationService;
import com.xebialabs.deployit.ascode.service.validation.DeploymentValidator;
import com.xebialabs.deployit.ascode.yaml.model.Constants$Kinds$;
import com.xebialabs.deployit.ascode.yaml.model.DeploymentSpec;
import com.xebialabs.deployit.core.rest.DryRunResource;
import com.xebialabs.deployit.core.rest.PreviewResource;
import com.xebialabs.deployit.core.rest.view.PreviewResult;
import com.xebialabs.deployit.engine.api.DeploymentService;
import com.xebialabs.deployit.engine.api.dto.ChangeSetDto;
import com.xebialabs.deployit.engine.api.dto.Deployment;
import com.xebialabs.deployit.engine.api.dto.DryRunDeploymentDto;
import com.xebialabs.deployit.engine.api.execution.BlockState;
import com.xebialabs.deployit.engine.api.execution.StepBlockState;
import com.xebialabs.deployit.engine.api.execution.StepState;
import com.xebialabs.deployit.engine.api.execution.TaskPreviewBlock;
import com.xebialabs.deployit.engine.tasker.Block;
import com.xebialabs.deployit.engine.tasker.ParallelBlock;
import com.xebialabs.deployit.engine.tasker.Phase;
import com.xebialabs.deployit.engine.tasker.PhaseContainer;
import com.xebialabs.deployit.engine.tasker.SerialBlock;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Service
@Autowired
@ScalaSignature(bytes="\u0006\u0005\u0005ee\u0001B\u0007\u000f\u0001eA\u0001\u0002\t\u0001\u0003\u0002\u0003\u0006I!\t\u0005\tS\u0001\u0011\t\u0011)A\u0005U!A!\u0007\u0001B\u0001B\u0003%1\u0007\u0003\u00058\u0001\t\u0005\t\u0015!\u00039\u0011!Y\u0004A!A!\u0002\u0013a\u0004\u0002\u0003#\u0001\u0005\u0003\u0005\u000b\u0011B#\t\u000b-\u0003A\u0011\u0001'\t\u000bQ\u0003A\u0011B+\t\u000b]\u0004A\u0011\u0002=\t\u0013\u0005e\u0001!%A\u0005\n\u0005m\u0001bBA\u0019\u0001\u0011%\u00111\u0007\u0005\b\u0003'\u0002A\u0011AA+\u00059\u0001&/\u001a<jK^\u001cVM\u001d<jG\u0016T!a\u0004\t\u0002\u000fM,'O^5dK*\u0011\u0011CE\u0001\u0007CN\u001cw\u000eZ3\u000b\u0005M!\u0012\u0001\u00033fa2|\u00170\u001b;\u000b\u0005U1\u0012!\u0003=fE&\fG.\u00192t\u0015\u00059\u0012aA2p[\u000e\u00011C\u0001\u0001\u001b!\tYb$D\u0001\u001d\u0015\u0005i\u0012!B:dC2\f\u0017BA\u0010\u001d\u0005\u0019\te.\u001f*fM\u0006\tB-\u001a9m_flWM\u001c;TKJ4\u0018nY3\u0011\u0005\t:S\"A\u0012\u000b\u0005\u0011*\u0013aA1qS*\u0011aEE\u0001\u0007K:<\u0017N\\3\n\u0005!\u001a#!\u0005#fa2|\u00170\\3oiN+'O^5dK\u0006)2\u000f^5uG\"\u0004&/\u001a<jK^\u0014Vm]8ve\u000e,\u0007CA\u00161\u001b\u0005a#BA\u0017/\u0003\u0011\u0011Xm\u001d;\u000b\u0005=\u0012\u0012\u0001B2pe\u0016L!!\r\u0017\u0003\u001fA\u0013XM^5foJ+7o\\;sG\u0016\fAc\u001d;ji\u000eD\u0007K]3wS\u0016<8+\u001a:wS\u000e,\u0007C\u0001\u001b6\u001b\u0005q\u0011B\u0001\u001c\u000f\u0005Q\u0019F/\u001b;dQB\u0013XM^5foN+'O^5dK\u0006qAM]=Sk:\u0014Vm]8ve\u000e,\u0007CA\u0016:\u0013\tQDF\u0001\bEef\u0014VO\u001c*fg>,(oY3\u00029\u0011,\u0007\u000f\\8z[\u0016tG\u000f\u0015:fa\u0006\u0014\u0018\r^5p]N+'O^5dKB\u0011QHQ\u0007\u0002})\u0011q\bQ\u0001\u0005kRLGN\u0003\u0002B\u001d\u0005!1\u000f]3d\u0013\t\u0019eH\u0001\u000fEKBdw._7f]R\u0004&/\u001a9be\u0006$\u0018n\u001c8TKJ4\u0018nY3\u0002'\u0011,\u0007\u000f\\8z[\u0016tGOV1mS\u0012\fGo\u001c:\u0011\u0005\u0019KU\"A$\u000b\u0005!s\u0011A\u0003<bY&$\u0017\r^5p]&\u0011!j\u0012\u0002\u0014\t\u0016\u0004Hn\\=nK:$h+\u00197jI\u0006$xN]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000f5su\nU)S'B\u0011A\u0007\u0001\u0005\u0006A\u001d\u0001\r!\t\u0005\u0006S\u001d\u0001\rA\u000b\u0005\u0006e\u001d\u0001\ra\r\u0005\u0006o\u001d\u0001\r\u0001\u000f\u0005\u0006w\u001d\u0001\r\u0001\u0010\u0005\u0006\t\u001e\u0001\r!R\u0001\u0013iJ\fgn\u001d4pe6\u001cF/\u001a9Ti\u0006$X\r\u0006\u0002W_B\u0011q\u000b\u001c\b\u00031&t!!\u00174\u000f\u0005i\u001bgBA.c\u001d\ta\u0016M\u0004\u0002^A6\taL\u0003\u0002`1\u00051AH]8pizJ\u0011aF\u0005\u0003+YI!!\u0005\u000b\n\u0005\u0011,\u0017\u0001B=b[2T!!\u0005\u000b\n\u0005\u001dD\u0017a\u00013u_*\u0011A-Z\u0005\u0003U.\fq\u0002\u0015:fm&,wOU3ta>t7/\u001a\u0006\u0003O\"L!!\u001c8\u0003\u001fQ\u000b7o\u001b)sKZLWm^%uK6T!A[6\t\u000bAD\u0001\u0019A9\u0002\u0013M$X\r]*uCR,\u0007C\u0001:v\u001b\u0005\u0019(B\u0001;$\u0003%)\u00070Z2vi&|g.\u0003\u0002wg\nI1\u000b^3q'R\fG/Z\u0001\u0014iJ\fgn\u001d4pe6\u0014En\\2l'R\fG/\u001a\u000b\u0006s\u0006\u0015\u0011q\u0002\t\u0004u~4fBA>~\u001d\tiF0C\u0001\u001e\u0013\tqH$A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\u0005\u00111\u0001\u0002\u0005\u0019&\u001cHO\u0003\u0002\u007f9!9\u0011qA\u0005A\u0002\u0005%\u0011A\u00032m_\u000e\\7\u000b^1uKB\u0019!/a\u0003\n\u0007\u000551O\u0001\u0006CY>\u001c7n\u0015;bi\u0016D\u0011\"!\u0005\n!\u0003\u0005\r!a\u0005\u0002\u0015%\u001c\b+\u0019:bY2,G\u000eE\u0002\u001c\u0003+I1!a\u0006\u001d\u0005\u001d\u0011un\u001c7fC:\fQ\u0004\u001e:b]N4wN]7CY>\u001c7n\u0015;bi\u0016$C-\u001a4bk2$HEM\u000b\u0003\u0003;QC!a\u0005\u0002 -\u0012\u0011\u0011\u0005\t\u0005\u0003G\ti#\u0004\u0002\u0002&)!\u0011qEA\u0015\u0003%)hn\u00195fG.,GMC\u0002\u0002,q\t!\"\u00198o_R\fG/[8o\u0013\u0011\ty#!\n\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\nhKR$\u0016m]6EKN\u001c'/\u001b9uS>tG\u0003BA\u001b\u0003\u000b\u0002B!a\u000e\u0002@9!\u0011\u0011HA\u001e!\tiF$C\u0002\u0002>q\ta\u0001\u0015:fI\u00164\u0017\u0002BA!\u0003\u0007\u0012aa\u0015;sS:<'bAA\u001f9!9\u0011qI\u0006A\u0002\u0005%\u0013A\u00033fa2|\u00170\\3oiB!\u00111JA(\u001b\t\tiE\u0003\u0002hG%!\u0011\u0011KA'\u0005)!U\r\u001d7ps6,g\u000e^\u0001\baJ,g/[3x)\u0011\t9&a\u0018\u0011\t\u0005e\u00131L\u0007\u0002W&\u0019\u0011QL6\u0003\u001fA\u0013XM^5foJ+7\u000f]8og\u0016Dq!!\u0019\r\u0001\u0004\t\u0019'\u0001\u0006eK\u001aLg.\u001b;j_:\u0004B!!\u001a\u0002l5\u0011\u0011q\r\u0006\u0004\u0003SB\u0017!B7pI\u0016d\u0017\u0002BA7\u0003O\u0012!\u0002R3gS:LG/[8oQ\r\u0001\u0011\u0011\u000f\t\u0005\u0003g\n\t)\u0004\u0002\u0002v)!\u0011qOA=\u0003)\u0019H/\u001a:f_RL\b/\u001a\u0006\u0005\u0003w\ni(A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\t\ty(A\u0002pe\u001eLA!a!\u0002v\t91+\u001a:wS\u000e,\u0007f\u0001\u0001\u0002\bB!\u0011\u0011RAK\u001b\t\tYI\u0003\u0003\u0002,\u00055%\u0002BAH\u0003#\u000bqAZ1di>\u0014\u0018P\u0003\u0003\u0002\u0014\u0006e\u0014!\u00022fC:\u001c\u0018\u0002BAL\u0003\u0017\u0013\u0011\"Q;u_^L'/\u001a3")
public class PreviewService {
    private final DeploymentService deploymentService;
    private final PreviewResource stitchPreviewResource;
    private final StitchPreviewService stitchPreviewService;
    private final DryRunResource dryRunResource;
    private final DeploymentPreparationService deploymentPreparationService;
    private final DeploymentValidator deploymentValidator;

    private PreviewResponse.TaskPreviewItem transformStepState(StepState stepState) {
        return new PreviewResponse.TaskPreviewItem(stepState.getDescription(), (List)Nil$.MODULE$, PreviewResponse.TaskPreviewItem$.MODULE$.apply$default$3());
    }

    private List<PreviewResponse.TaskPreviewItem> transformBlockState(BlockState blockState, boolean isParallel) {
        BlockState blockState2;
        while (true) {
            if ((blockState2 = blockState) instanceof PhaseContainer) {
                PhaseContainer phaseContainer = (PhaseContainer)blockState2;
                List children = phaseContainer.phases().toList().flatMap((Function1 & Serializable)x$1 -> this.transformBlockState((BlockState)x$1, this.transformBlockState$default$2()));
                return (List)Option$.MODULE$.apply((Object)phaseContainer.description()).filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$2)))).map((Function1 & Serializable)desc -> {
                    PreviewResponse.TaskPreviewItem taskPreviewItem = new PreviewResponse.TaskPreviewItem(desc, children, isParallel);
                    return Nil$.MODULE$.$colon$colon((Object)taskPreviewItem);
                }).getOrElse((Function0 & Serializable)() -> children);
            }
            if (blockState2 instanceof ParallelBlock) {
                ParallelBlock parallelBlock = (ParallelBlock)blockState2;
                String description = parallelBlock.description();
                Seq blocks = parallelBlock.blocks();
                PreviewResponse.TaskPreviewItem taskPreviewItem = new PreviewResponse.TaskPreviewItem(description, blocks.toList().flatMap((Function1 & Serializable)x$3 -> this.transformBlockState((BlockState)x$3, true)), isParallel);
                return Nil$.MODULE$.$colon$colon((Object)taskPreviewItem);
            }
            if (blockState2 instanceof SerialBlock) {
                SerialBlock serialBlock = (SerialBlock)blockState2;
                String description = serialBlock.description();
                Seq blocks = serialBlock.blocks();
                PreviewResponse.TaskPreviewItem taskPreviewItem = new PreviewResponse.TaskPreviewItem(description, blocks.toList().flatMap((Function1 & Serializable)x$4 -> this.transformBlockState((BlockState)x$4, this.transformBlockState$default$2())), isParallel);
                return Nil$.MODULE$.$colon$colon((Object)taskPreviewItem);
            }
            if (blockState2 instanceof StepBlockState) {
                StepBlockState stepBlockState = (StepBlockState)blockState2;
                PreviewResponse.TaskPreviewItem taskPreviewItem = new PreviewResponse.TaskPreviewItem(stepBlockState.getDescription(), CollectionConverters$.MODULE$.ListHasAsScala(stepBlockState.getSteps()).asScala().toList().map((Function1 & Serializable)stepState -> this.transformStepState((StepState)stepState)), isParallel);
                return Nil$.MODULE$.$colon$colon((Object)taskPreviewItem);
            }
            if (!(blockState2 instanceof Phase)) break;
            Phase phase = (Phase)blockState2;
            isParallel = this.transformBlockState$default$2();
            blockState = phase.block();
        }
        if (blockState2 instanceof Block) {
            Block block = (Block)blockState2;
            PreviewResponse.TaskPreviewItem taskPreviewItem = new PreviewResponse.TaskPreviewItem(block.description(), CollectionConverters$.MODULE$.ListHasAsScala(block.getStepList()).asScala().toList().map((Function1 & Serializable)stepState -> this.transformStepState((StepState)stepState)), isParallel);
            return Nil$.MODULE$.$colon$colon((Object)taskPreviewItem);
        }
        return Nil$.MODULE$;
    }

    private boolean transformBlockState$default$2() {
        return false;
    }

    private String getTaskDescription(Deployment deployment) {
        String string;
        Deployment.DeploymentType deploymentType = deployment.getDeploymentType();
        if (Deployment.DeploymentType.INITIAL.equals(deploymentType)) {
            string = "deployed to";
        } else if (Deployment.DeploymentType.UPDATE.equals(deploymentType)) {
            string = "updated on";
        } else if (Deployment.DeploymentType.UNDEPLOYMENT.equals(deploymentType)) {
            string = "un-deployed from";
        } else {
            throw new MatchError((Object)deploymentType);
        }
        String typeRelatedPart = string;
        ConfigurationItem configurationItem = deployment.getDeployedApplication();
        if (configurationItem instanceof DeployedApplication) {
            DeployedApplication deployedApplication = (DeployedApplication)configurationItem;
            return "Application '" + deployedApplication.getVersion().getId() + "' will be " + typeRelatedPart + " '" + deployedApplication.getEnvironment().getId() + "'";
        }
        throw new MatchError((Object)configurationItem);
    }

    public PreviewResponse preview(Definition definition) {
        String string = definition.kind();
        String string2 = Constants$Kinds$.MODULE$.DEPLOYMENT();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            DeploymentSpec spec = (DeploymentSpec)definition.spec();
            Deployment deployment = this.deploymentPreparationService.deploymentSpecToDeployment(spec);
            Deployment validatedDeployment = this.deploymentValidator.validate(deployment);
            TaskPreviewBlock taskPreviewBlock = this.deploymentService.taskPreviewBlock(validatedDeployment);
            List<PreviewResponse.TaskPreviewItem> taskPreviewItems = this.transformBlockState(taskPreviewBlock.getBlock(), this.transformBlockState$default$2());
            return new PreviewResponse((Option)new Some((Object)new PreviewResponse.TaskInfo(this.getTaskDescription(deployment), taskPreviewItems)));
        }
        String string3 = definition.kind();
        String string4 = Constants$Kinds$.MODULE$.STITCH_PREVIEW();
        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
            DeploymentSpec spec = (DeploymentSpec)definition.spec();
            Deployment deployment = this.deploymentPreparationService.deploymentSpecToDeployment(spec);
            PreviewResult stitchPreviewBlock = this.stitchPreviewResource.preview(deployment);
            List<PreviewResponse.TaskPreviewItem> stitchPreviewItems = this.stitchPreviewService.transformStitchPreviewResult(stitchPreviewBlock);
            return new PreviewResponse((Option)new Some((Object)new PreviewResponse.TaskInfo(this.stitchPreviewService.getStitchTaskDescription(deployment, "Generating stitch preview for the deployment of application"), stitchPreviewItems)));
        }
        String string5 = definition.kind();
        String string6 = Constants$Kinds$.MODULE$.STITCH_DRYRUN();
        if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
            DeploymentSpec spec = (DeploymentSpec)definition.spec();
            Deployment deployment = this.deploymentPreparationService.deploymentSpecToDeployment(spec);
            PreviewResult dryRunPreviewResult = this.dryRunResource.dryRun(new DryRunDeploymentDto(new ChangeSetDto(spec.stitchSource(), spec.branchName()), deployment));
            List<PreviewResponse.TaskPreviewItem> stitchPreviewItems = this.stitchPreviewService.transformStitchPreviewResult(dryRunPreviewResult);
            return new PreviewResponse((Option)new Some((Object)new PreviewResponse.TaskInfo(this.stitchPreviewService.getStitchTaskDescription(deployment, "Generating DryRun preview on CI '" + spec.stitchSource() + "' and branch '" + spec.branchName() + "' for the deployment of application"), stitchPreviewItems)));
        }
        throw new AsCodeException("Cannot preview '" + definition.kind() + "' spec. Only '" + Constants$Kinds$.MODULE$.DEPLOYMENT() + "' and '" + Constants$Kinds$.MODULE$.STITCH_PREVIEW() + "' spec kind are supported.", AsCodeException$.MODULE$.$lessinit$greater$default$2());
    }

    public PreviewService(DeploymentService deploymentService, PreviewResource stitchPreviewResource, StitchPreviewService stitchPreviewService, DryRunResource dryRunResource, DeploymentPreparationService deploymentPreparationService, DeploymentValidator deploymentValidator) {
        this.deploymentService = deploymentService;
        this.stitchPreviewResource = stitchPreviewResource;
        this.stitchPreviewService = stitchPreviewService;
        this.dryRunResource = dryRunResource;
        this.deploymentPreparationService = deploymentPreparationService;
        this.deploymentValidator = deploymentValidator;
    }
}

