package com.xebialabs.deployit.ascode.yaml.parser.spec.user

import com.fasterxml.jackson.databind.{JsonNode, ObjectMapper}
import com.xebialabs.ascode.yaml.model.{Spec, UsersSpec}
import com.xebialabs.ascode.yaml.parser.SpecParser
import com.xebialabs.ascode.yaml.parser.util.JsonNodeSugar._
import com.xebialabs.deployit.ascode.yaml.model.user.XLDUser

import scala.jdk.CollectionConverters._

object XLDUsersSpecParser extends SpecParser {
  override def parse(definitionKind: String,
                     metadata: Option[Map[String, String]],
                     node: JsonNode)(implicit mapper: ObjectMapper): Spec = {
    val users = node.elements().asScala.map { user =>
      val username = user.requiredString("username")
      val password = user.requiredString("password")
      val name = user.string("name")
      val email = user.string("email")
      val enabled = user.requiredBoolean("enabled")
      XLDUser(username, password, name, email, enabled)
    }.toList
    UsersSpec(users)
  }
}
