package com.xebialabs.deployit.ascode.service.generator

import com.xebialabs.ascode.yaml.model.{Definition, UsersSpec}
import com.xebialabs.deployit.ascode.yaml.model.Constants.Kinds._
import com.xebialabs.deployit.ascode.yaml.model.Constants.Versions._
import com.xebialabs.deployit.ascode.yaml.model.user.XLDUser
import com.xebialabs.deployit.core.rest.api.UserResource
import com.xebialabs.deployit.engine.api.security.User
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import scala.jdk.CollectionConverters._

@Component
@Autowired
class UsersGenerator(userResource: UserResource) extends DefinitionGenerator {
  private def userToAsCode(user: User): XLDUser = {
    XLDUser(user.getUsername, user.getPassword, Option(user.getUserProfile.getFullName).filterNot(_.isEmpty), Option(user.getUserProfile.getEmail).filterNot(_.isEmpty), user.getUserProfile.getLoginAllowed)
  }

  override def generate(config: DefinitionGeneratorService.GeneratorConfig, cis: List[ConfigurationItem]): List[Definition] = {
    if (config.users) {
      val users = userResource
        .listUserNames(null, null, null)
        .asScala
        .map(username => userToAsCode(userResource.read(username)))
        .toList

      if (users.nonEmpty) {
        Definition(XLD_API_VERSION, None, USERS, UsersSpec(users)) :: Nil
      } else Nil
    } else Nil
  }
}
