package com.xebialabs.deployit.ascode.yaml.writer.spec

import com.fasterxml.jackson.databind.ObjectMapper
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator
import com.xebialabs.ascode.yaml.model.{CiSpec, Spec}
import com.xebialabs.ascode.yaml.sugar.SugarConfig
import com.xebialabs.ascode.yaml.writer.DefinitionWriter.WriterConfig
import com.xebialabs.ascode.yaml.writer.support.{ConfigurationItemGenerator, JacksonCiWriter}
import com.xebialabs.ascode.yaml.writer.{GenerateContext, SpecWriter}

import scala.jdk.CollectionConverters._

class CiSpecWriter(implicit sugarConfig: SugarConfig) extends SpecWriter {
  override def write(spec: Spec, yamlGenerator: YAMLGenerator)(implicit mapper: ObjectMapper, config: WriterConfig): GenerateContext = {
    val ciSpec = spec.asInstanceOf[CiSpec]
    val writer = new JacksonCiWriter(yamlGenerator)
    val converter = new ConfigurationItemGenerator
    converter.writeCis(ciSpec.cis.asJava, writer, Int.MaxValue)
    GenerateContext(converter.additionalFiles, converter.secrets)
  }
}
