package com.xebialabs.deployit.ascode.service.generator
import com.xebialabs.ascode.yaml.model.{CiSpec, Definition}
import com.xebialabs.deployit.ascode.yaml.model.Constants.Versions.XLD_API_VERSION
import com.xebialabs.deployit.core.util.IdExtensions._
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

@Component
@Autowired
class CiDefinitionGenerator extends DefinitionGenerator {
  override def generate(config: DefinitionGeneratorService.GeneratorConfig,
                        cis: List[ConfigurationItem]): List[Definition] = {
    config.ciId.map { path =>
      Definition(XLD_API_VERSION, None, path.getRoot, CiSpec(cis)) :: Nil
    }.toList.flatten
  }
}
