package com.xebialabs.deployit.ascode.service

import com.xebialabs.ascode.yaml.model.{CiSpec, Spec}
import com.xebialabs.deployit.ascode.yaml.model.DeploymentSpec
import com.xebialabs.deployit.plugin.api.services.Repository
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem
import com.xebialabs.xltype.serialization.util.ReferenceUtils

import scala.jdk.CollectionConverters._

object CiReferenceResolver {

  /**
    * Resolve references for all cis specs in all definitions
    * @param spec - specification instance
    * @param repository - repository instance to query for CIs if they are not in definitions
    */
  def resolve(spec: Spec, repository: Repository): Unit = {
    val (references, ciMap) = spec match {
      case ref: CiSpec =>
        ref.references -> ref.cis.map(ci => ci.getId -> ci).toMap
      case deploymentSpec: DeploymentSpec =>
        deploymentSpec.references -> Map[String, ConfigurationItem]()
      case _ => Nil -> Map[String, ConfigurationItem]()
    }
    ReferenceUtils.resolveReferences(references.asJava, ciMap.asJava, repository)
  }
}
