package com.xebialabs.deployit.ascode.yaml.parser

import java.io.InputStream

import com.xebialabs.ascode.yaml.Specs
import com.xebialabs.ascode.yaml.model.Definition
import com.xebialabs.ascode.yaml.parser.{DefinitionParser, RolesSpecParser, SpecParser}
import com.xebialabs.ascode.yaml.sugar.SugarConfig
import com.xebialabs.deployit.ascode.yaml.model.Constants.Kinds._
import com.xebialabs.deployit.ascode.yaml.parser.spec.ci.CiSpecParser
import com.xebialabs.deployit.ascode.yaml.parser.spec.deployment.DeploymentSpecParser
import com.xebialabs.deployit.ascode.yaml.parser.spec.permission.XLDPermissionSpecParser
import com.xebialabs.deployit.ascode.yaml.parser.spec.user.XLDUsersSpecParser
import org.springframework.stereotype.Component

@Component
class XLDDefinitionParser {
  def specs(implicit config: SugarConfig): Specs[SpecParser] = DefinitionParser.specs(
    "xl-deploy",
    List(INFRASTRUCTURE, ENVIRONMENTS, APPLICATIONS, CONFIGURATION) -> new CiSpecParser,
    List(DEPLOYMENT, STITCH_PREVIEW,STITCH_DRYRUN) -> DeploymentSpecParser,
    List(PERMISSIONS) -> XLDPermissionSpecParser(),
    List(ROLES) -> RolesSpecParser,
    List(USERS) -> XLDUsersSpecParser
  )

  def parse(content: InputStream)(implicit config: SugarConfig): Definition = new DefinitionParser(specs).parse(content)
}
