package com.xebialabs.ascode.yaml.writer.support

import com.xebialabs.deployit.util.PasswordEncrypter

object SecretsIdUtils {
  private def idToKey(id: String): String = {
    id.replaceAll("[^A-Za-z0-9_]", "_")
  }

  def buildUniqueKey(key: String, hasKey: String => Boolean): String = {
    val sanitized = idToKey(key)
    if (hasKey(sanitized)) {
      Stream.from(0).map(i => s"${sanitized}_$i").dropWhile(hasKey).head
    } else sanitized
  }

  private def decryptIfNeeded(value: String): String = {
    val encrypter = PasswordEncrypter.getInstance()
    if (encrypter.isEncrypted(value))
      encrypter.decrypt(value)
    else
      value
  }

  def addToMapUnique(key: String, value: String, secrets: Map[String, String]): (String, Map[String, String]) = {
    val uniqueKey = buildUniqueKey(key, secrets.contains)
    (uniqueKey, secrets + (uniqueKey -> decryptIfNeeded(value.toString)))
  }
}
