package com.xebialabs.ascode.yaml.writer
import com.fasterxml.jackson.databind.ObjectMapper
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator
import com.xebialabs.ascode.yaml.model.{RolesSpec, Spec}
import com.xebialabs.ascode.yaml.writer.DefinitionWriter.WriterConfig

object RolesWriter extends SpecWriter {
  override def write(spec: Spec, yamlGenerator: YAMLGenerator)(implicit mapper: ObjectMapper, config: WriterConfig): GenerateContext = {
    val rolesSpec = spec.asInstanceOf[RolesSpec]
    mapper.writeValue(yamlGenerator, rolesSpec.roles)
    GenerateContext()
  }
}
