package com.xebialabs.ascode.utils

import com.xebialabs.deployit.plugin.api.reflect.{Descriptor, PropertyDescriptor, Type}
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact

import scala.reflect.ClassTag

object TypeSugar {
  def typeOf[T](implicit classTag: ClassTag[T]): Type = Type.valueOf(classTag.runtimeClass)
  def typeOf(typeName: String): Type = Type.valueOf(typeName)

  def newCi[T](id: String)(implicit classTag: ClassTag[T]): T = typeOf[T](classTag).getDescriptor.newInstance(id)

  implicit class ExtendedType(ciType: Type) {
    def isArtifact: Boolean = ciType.instanceOf(typeOf[Artifact])
    def prop(name: String): PropertyDescriptor = ciType.getDescriptor.getPropertyDescriptor(name)
  }

  implicit class ExtendedDescriptor(descr: Descriptor) {
    def isInstance[T](implicit classTag: ClassTag[T]): Boolean = descr.getType.instanceOf(typeOf[T])
  }
}
