package com.xebialabs.ascode.exception

import java.util

import com.xebialabs.ascode.yaml.dto.AsCodeResponse.{CiValidationError, DocumentFieldError, PermissionError}
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem
import com.xebialabs.deployit.service.validation.Validator.ValidationsFailedException

import scala.collection.convert.ImplicitConversions._

object AsCodeException {
  private def getCause(e: Throwable): Throwable = Option(e.getCause) match {
    case Some(cause) => getCause(cause)
    case None => e
  }

  def wrapUnhandled[T](op: => T): T = {
    try {
      op
    } catch {
      case e: Throwable => getCause(e) match {
        case ex: AsCodeException => throw ex
        case ex: ValidationsFailedException => throw CiValidationException({
          val items = ex.getEntity match {
            case collection: util.Collection[_] => collection.toList
            case iterable: Iterable[_] => iterable.toList
          }
          items
            .asInstanceOf[List[ConfigurationItem]]
            .flatMap(_.get$validationMessages())
            .map(message => CiValidationError(message.getCiId, message.getPropertyName, message.getMessage))
        })
        case ex: Throwable => throw new AsCodeException(cause = ex)
      }
    }
  }

  def throwDocumentFieldException(field: String, problem: String): Nothing = {
    throw DocumentValidationException(DocumentFieldError(field, problem))
  }

  def throwCiFieldValidationException(id: String, field: String, problem: String): Nothing = {
    throw CiValidationException(CiValidationError(id, field, problem) :: Nil)
  }
}

case class CiPermissionException(permissionErrors: List[PermissionError]) extends AsCodeException

case class CiValidationException(errors: List[CiValidationError]) extends AsCodeException

case class DocumentValidationException(error: DocumentFieldError) extends AsCodeException

class AsCodeException(msg: String = null, cause: Throwable = null) extends RuntimeException(msg, cause)