/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.deployfile.execute;

import com.xebialabs.deployit.core.rest.api.InvalidDeploymentException;
import com.xebialabs.deployit.deployfile.execute.CiCommand;
import com.xebialabs.deployit.deployfile.execute.CommandExecutor$;
import com.xebialabs.deployit.deployfile.execute.DeployfileCommand;
import com.xebialabs.deployit.deployfile.execute.DeploymentCommand;
import com.xebialabs.deployit.deployfile.execute.PermissionCommand;
import com.xebialabs.deployit.deployfile.execute.ProgressCollector;
import com.xebialabs.deployit.engine.api.dto.Deployment;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.ChangeSet;
import com.xebialabs.deployit.repository.ProgressLogger;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.security.PermissionEditor;
import com.xebialabs.deployit.service.deployment.DeploymentTaskService;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Component
@ScalaSignature(bytes="\u0006\u0001\u0005Me\u0001B\u0001\u0003\u00015\u0011qbQ8n[\u0006tG-\u0012=fGV$xN\u001d\u0006\u0003\u0007\u0011\tq!\u001a=fGV$XM\u0003\u0002\u0006\r\u0005QA-\u001a9m_f4\u0017\u000e\\3\u000b\u0005\u001dA\u0011\u0001\u00033fa2|\u00170\u001b;\u000b\u0005%Q\u0011!\u0003=fE&\fG.\u00192t\u0015\u0005Y\u0011aA2p[\u000e\u00011C\u0001\u0001\u000f!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fM\"AQ\u0003\u0001B\u0001B\u0003%a#A\tsKB|7/\u001b;pef\u001cVM\u001d<jG\u0016\u0004\"a\u0006\u000e\u000e\u0003aQ!!\u0007\u0004\u0002\u0015I,\u0007o\\:ji>\u0014\u00180\u0003\u0002\u001c1\t\t\"+\u001a9pg&$xN]=TKJ4\u0018nY3)\u0005Qi\u0002C\u0001\u0010*\u001b\u0005y\"B\u0001\u0011\"\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003E\r\nqAZ1di>\u0014\u0018P\u0003\u0002%K\u0005)!-Z1og*\u0011aeJ\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\t\u0001&A\u0002pe\u001eL!AK\u0010\u0003\u0013\u0005+Ho\\<je\u0016$\u0007\u0002\u0003\u0017\u0001\u0005\u0003\u0005\u000b\u0011B\u0017\u0002!A,'/\\5tg&|g.\u00123ji>\u0014\bC\u0001\u00182\u001b\u0005y#B\u0001\u0019\u0007\u0003!\u0019XmY;sSRL\u0018B\u0001\u001a0\u0005A\u0001VM]7jgNLwN\\#eSR|'\u000f\u000b\u0002,;!AQ\u0007\u0001B\u0001B\u0003%a'A\u000beKBdw._7f]R$\u0016m]6TKJ4\u0018nY3\u0011\u0005]bT\"\u0001\u001d\u000b\u0005eR\u0014A\u00033fa2|\u00170\\3oi*\u00111HB\u0001\bg\u0016\u0014h/[2f\u0013\ti\u0004HA\u000bEKBdw._7f]R$\u0016m]6TKJ4\u0018nY3)\u0005Qj\u0002\"\u0002!\u0001\t\u0003\t\u0015A\u0002\u001fj]&$h\b\u0006\u0003C\t\u001aC\u0005CA\"\u0001\u001b\u0005\u0011\u0001\"B\u000b@\u0001\u00041\u0002F\u0001#\u001e\u0011\u0015as\b1\u0001.Q\t1U\u0004C\u00036\u007f\u0001\u0007a\u0007\u000b\u0002I;!)1\u0001\u0001C\u0001\u0017R\u0011A\n\u0019\t\u0004\u001bVCfB\u0001(T\u001d\ty%+D\u0001Q\u0015\t\tF\"\u0001\u0004=e>|GOP\u0005\u0002#%\u0011A\u000bE\u0001\ba\u0006\u001c7.Y4f\u0013\t1vK\u0001\u0003MSN$(B\u0001+\u0011!\tIVL\u0004\u0002[7B\u0011q\nE\u0005\u00039B\ta\u0001\u0015:fI\u00164\u0017B\u00010`\u0005\u0019\u0019FO]5oO*\u0011A\f\u0005\u0005\u0006C*\u0003\rAY\u0001\tG>lW.\u00198egB\u0019Q*V2\u0011\u0005\r#\u0017BA3\u0003\u0005E!U\r\u001d7ps\u001aLG.Z\"p[6\fg\u000e\u001a\u0005\u0006O\u0002!I\u0001[\u0001\u0006gBd\u0017\u000e\u001e\u000b\u0003Sb\u0004Ra\u00046maRL!a\u001b\t\u0003\rQ+\b\u000f\\34!\riU+\u001c\t\u0003\u0007:L!a\u001c\u0002\u0003\u0013\rK7i\\7nC:$\u0007cA'VcB\u00111I]\u0005\u0003g\n\u0011\u0011\u0003U3s[&\u001c8/[8o\u0007>lW.\u00198e!\riU+\u001e\t\u0003\u0007ZL!a\u001e\u0002\u0003#\u0011+\u0007\u000f\\8z[\u0016tGoQ8n[\u0006tG\rC\u0003bM\u0002\u0007!\rC\u0003{\u0001\u0011%10\u0001\u0006fq\u0016\u001cW\u000f^3DSN$\"\u0001\u0014?\t\u000buL\b\u0019\u00017\u0002\u0015\rL7i\\7nC:$7\u000f\u0003\u0004\u0000\u0001\u0011\u0005\u0011\u0011A\u0001\u0013Kb,7-\u001e;f!\u0016\u0014X.[:tS>t7\u000fF\u0002M\u0003\u0007Aa!!\u0002\u007f\u0001\u0004\u0001\u0018A\u00059fe6L7o]5p]\u000e{W.\\1oINDq!!\u0003\u0001\t\u0013\tY!\u0001\nfq\u0016\u001cW\u000f^3EKBdw._7f]R\u001cHc\u0001'\u0002\u000e!9\u0011qBA\u0004\u0001\u0004!\u0018A\u00053fa2|\u00170\\3oi\u000e{W.\\1oINDq!a\u0005\u0001\t\u0013\t)\"A\teKBdw._!qa2L7-\u0019;j_:$2\u0001WA\f\u0011\u001d\tI\"!\u0005A\u0002U\fqaY8n[\u0006tG\rC\u0004\u0002\u001e\u0001!I!a\b\u0002+\u001d,GOV1mS\u0012\fG/[8o\u001b\u0016\u001c8/Y4fgR\u0019\u0001,!\t\t\u000fe\nY\u00021\u0001\u0002$A!\u0011QEA\u001a\u001b\t\t9C\u0003\u0003\u0002*\u0005-\u0012a\u00013u_*!\u0011QFA\u0018\u0003\r\t\u0007/\u001b\u0006\u0004\u0003c1\u0011AB3oO&tW-\u0003\u0003\u00026\u0005\u001d\"A\u0003#fa2|\u00170\\3oi\"9\u0011Q\u0004\u0001\u0005\n\u0005eBc\u0001-\u0002<!A\u0011QHA\u001c\u0001\u0004\ty$\u0001\u0002dSB!\u0011\u0011IA'\u001b\t\t\u0019E\u0003\u0003\u0002F\u0005\u001d\u0013aA;e[*!\u0011QFA%\u0015\r\tYEB\u0001\u0007a2,x-\u001b8\n\t\u0005=\u00131\t\u0002\u0012\u0007>tg-[4ve\u0006$\u0018n\u001c8Ji\u0016l\u0007\"CA*\u0001\t\u0007I\u0011BA+\u0003\u0019awnZ4feV\u0011\u0011q\u000b\t\u0005\u00033\ny&\u0004\u0002\u0002\\)\u0019\u0011QL\u0014\u0002\u000bMdg\r\u000e6\n\t\u0005\u0005\u00141\f\u0002\u0007\u0019><w-\u001a:\t\u0011\u0005\u0015\u0004\u0001)A\u0005\u0003/\nq\u0001\\8hO\u0016\u0014\b\u0005K\u0002\u0001\u0003S\u0002B!a\u001b\u0002r5\u0011\u0011Q\u000e\u0006\u0004\u0003_*\u0013AC:uKJ,w\u000e^=qK&!\u00111OA7\u0005%\u0019u.\u001c9p]\u0016tGoB\u0004\u0002x\tA\t!!\u001f\u0002\u001f\r{W.\\1oI\u0016CXmY;u_J\u00042aQA>\r\u0019\t!\u0001#\u0001\u0002~M\u0019\u00111\u0010\b\t\u000f\u0001\u000bY\b\"\u0001\u0002\u0002R\u0011\u0011\u0011\u0010\u0005\u000b\u0003\u000b\u000bYH1A\u0005\u0006\u0005\u001d\u0015!\u0007$B\u00132+Ei\u0018#F!2{\u0015,T#O)~kUiU*B\u000f\u0016+\"!!#\u0010\u0005\u0005-\u0015EAAG\u0003\u0005m\u0005\u000b\\3bg\u0016\u0004c-\u001b=!i\",\u0007%[:tk\u0016D3/\u000b\u0011cK\u001a|'/\u001a\u0011sK\u0006\u0004\b\u000f\\=j]\u001e\u0004C\u000f[3!\t\u0016\u0004Hn\\=gS2,g\u0006\t+pAI,\u0017\r\u001d9ms\u0002\"\b.[:!\t\u0016\u0004Hn\\=gS2,G\u0006I=pk\u0002jWo\u001d;!M&\u00148\u000f\u001e\u0011eK2,G/\u001a\u0011uQ\u0016\u0004\u0003/Y2lC\u001e,\u0007E\u001a:p[\u0002BF\n\t#fa2|\u0017P\f\u0011UQ&\u001c\b%[:!C\u0002Zgn\\<oA1LW.\u001b;bi&|g\u000e\t;iCR\u0004s/\u001b7mA\t,\u0007E]3t_24X\r\u001a\u0011j]\u0002\n\u0007EZ;ukJ,\u0007E^3sg&|gN\f\u0005\n\u0003#\u000bY\b)A\u0007\u0003\u0013\u000b!DR!J\u0019\u0016#u\fR#Q\u0019>KV*\u0012(U?6+5kU!H\u000b\u0002\u0002")
public class CommandExecutor {
    @Autowired
    private final RepositoryService repositoryService;
    @Autowired
    private final PermissionEditor permissionEditor;
    @Autowired
    private final DeploymentTaskService deploymentTaskService;
    private final Logger logger;

    public static String FAILED_DEPLOYMENT_MESSAGE() {
        return CommandExecutor$.MODULE$.FAILED_DEPLOYMENT_MESSAGE();
    }

    public List<String> execute(List<DeployfileCommand> commands) {
        Tuple3<List<CiCommand>, List<PermissionCommand>, List<DeploymentCommand>> tuple3 = this.split(commands);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        List ciCommands = (List)tuple3._1();
        List permissionCommands = (List)tuple3._2();
        List deploymentCommands = (List)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)ciCommands, (Object)permissionCommands, (Object)deploymentCommands);
        Tuple3 tuple33 = tuple32;
        List ciCommands2 = (List)tuple33._1();
        List permissionCommands2 = (List)tuple33._2();
        List deploymentCommands2 = (List)tuple33._3();
        List<String> list = this.executeCis((List<CiCommand>)ciCommands2);
        List<String> list2 = this.executePermissions((List<PermissionCommand>)permissionCommands2);
        return this.executeDeployments((List<DeploymentCommand>)deploymentCommands2).$colon$colon$colon(list2).$colon$colon$colon(list);
    }

    private Tuple3<List<CiCommand>, List<PermissionCommand>, List<DeploymentCommand>> split(List<DeployfileCommand> commands) {
        Map grouped = commands.groupBy((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)CommandExecutor.$anonfun$split$1(x0$1)));
        return new Tuple3((Object)((List)grouped.getOrElse((Object)BoxesRunTime.boxToInteger((int)0), (Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$)), (Object)((List)grouped.getOrElse((Object)BoxesRunTime.boxToInteger((int)1), (Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$)), (Object)((List)grouped.getOrElse((Object)BoxesRunTime.boxToInteger((int)2), (Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$)));
    }

    private List<String> executeCis(List<CiCommand> ciCommands) {
        List<String> list;
        if (ciCommands.isEmpty()) {
            list = Nil$.MODULE$;
        } else {
            ChangeSet changeSet = new ChangeSet();
            ciCommands.foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                x$4.addTo(changeSet);
                return BoxedUnit.UNIT;
            });
            ProgressCollector progressCollector = new ProgressCollector();
            this.repositoryService.execute(changeSet, (ProgressLogger)progressCollector);
            list = progressCollector.summary();
        }
        return list;
    }

    public List<String> executePermissions(List<PermissionCommand> permissionCommands) {
        permissionCommands.foreach((Function1 & Serializable & scala.Serializable)command -> {
            this.permissionEditor.editPermissions(command.ci(), command.permissions());
            return BoxedUnit.UNIT;
        });
        return Nil$.MODULE$;
    }

    private List<String> executeDeployments(List<DeploymentCommand> deploymentCommands) {
        return (List)deploymentCommands.map((Function1 & Serializable & scala.Serializable)command -> this.deployApplication((DeploymentCommand)command), List$.MODULE$.canBuildFrom());
    }

    private String deployApplication(DeploymentCommand command) {
        String string;
        String appId = command.appId();
        String environmentId = command.environmentId();
        String version = command.version();
        boolean isDeployed = this.deploymentTaskService.isDeployed(appId, environmentId);
        String deployedApplicationId = environmentId + "/" + new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])appId.split("/"))).last();
        Deployment deployment = isDeployed ? this.deploymentTaskService.prepareUpdate(version, deployedApplicationId) : this.deploymentTaskService.prepareInitial(version, environmentId);
        Deployment deployeds = this.deploymentTaskService.prepareAutoDeployeds(deployment);
        try {
            this.deploymentTaskService.validate(deployeds);
            String taskId = this.deploymentTaskService.createTask(deployeds);
            this.deploymentTaskService.startDeploymentTask(taskId);
            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Started deployment: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{taskId}));
        }
        catch (InvalidDeploymentException e) {
            this.logger().error("deployment failed due to : ", new Object[]{e.getMessage()});
            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deployment failed due to: ", ". ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getValidationMessages(deployeds), "Please fix the issue(s) before reapplying the Deployfile. To reapply this Deployfile, you must first delete the package from XL Deploy. This is a known limitation that will be resolved in a future version."}));
        }
        catch (Exception e) {
            this.logger().error("deployment failed due to : ", new Object[]{e.getMessage()});
            throw e;
        }
        return string;
    }

    private String getValidationMessages(Deployment deployment) {
        return ((TraversableOnce)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(deployment.getDeployeds()).asScala()).filterNot((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)CommandExecutor.$anonfun$getValidationMessages$1(x$5)))).map((Function1 & Serializable & scala.Serializable)ci -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " on ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getValidationMessages((ConfigurationItem)ci), ci.getName()})), Buffer$.MODULE$.canBuildFrom())).mkString(", ");
    }

    private String getValidationMessages(ConfigurationItem ci) {
        return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(ci.get$validationMessages()).asScala()).map((Function1 & Serializable & scala.Serializable)message -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " for property '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{message.getMessage(), message.getPropertyName()})), Buffer$.MODULE$.canBuildFrom())).mkString(" and ");
    }

    private Logger logger() {
        return this.logger;
    }

    public static final /* synthetic */ int $anonfun$split$1(DeployfileCommand x0$1) {
        int n;
        DeployfileCommand deployfileCommand = x0$1;
        if (deployfileCommand instanceof CiCommand) {
            n = 0;
        } else if (deployfileCommand instanceof PermissionCommand) {
            n = 1;
        } else if (deployfileCommand instanceof DeploymentCommand) {
            n = 2;
        } else {
            throw new MatchError((Object)deployfileCommand);
        }
        return n;
    }

    public static final /* synthetic */ boolean $anonfun$getValidationMessages$1(ConfigurationItem x$5) {
        return x$5.get$validationMessages().isEmpty();
    }

    public CommandExecutor(@Autowired RepositoryService repositoryService, @Autowired PermissionEditor permissionEditor, @Autowired DeploymentTaskService deploymentTaskService) {
        this.repositoryService = repositoryService;
        this.permissionEditor = permissionEditor;
        this.deploymentTaskService = deploymentTaskService;
        this.logger = LoggerFactory.getLogger(CommandExecutor.class);
    }
}

