/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.secured;

import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.security.PermissionDeniedException;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.security.permission.PermissionHelper;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import java.util.Arrays;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractSecuredResource {
    @Autowired
    private RoleService roleService;

    protected void checkPermission(Permission permission) {
        this.checkPermission(permission, null);
    }

    protected void checkPermissions(Permission ... permissions) {
        this.checkPermissions(permissions, (String)null);
    }

    protected void checkPermission(Permission permission, String id) {
        if (!permission.getPermissionHandler().hasPermission(id)) {
            throw PermissionDeniedException.forPermission((Permission)permission, (String)id);
        }
    }

    protected void checkReadPermission(String id) {
        if (!this.roleService.isReadOnlyAdmin()) {
            this.checkPermission(PlatformPermissions.READ, id);
        }
    }

    protected void checkPermissions(Permission[] permissions, String id) {
        if (Strings.isBlank((String)id) ? !PermissionHelper.hasPermission((Permission[])permissions) : !PermissionHelper.hasPermission((Permission[])permissions, (String)id)) {
            throw PermissionDeniedException.forPermissions(Arrays.asList(permissions), (String)id);
        }
    }

    protected boolean hasPermission(Permission permission) {
        return this.hasPermission(permission, null);
    }

    protected boolean hasPermission(Permission permission, String id) {
        return permission.getPermissionHandler().hasPermission(id);
    }

    protected boolean hasReadPermission(String id) {
        return PlatformPermissions.READ.getPermissionHandler().hasPermission(id) || this.roleService.isReadOnlyAdmin();
    }

    public void setRoleService(RoleService roleService) {
        this.roleService = roleService;
    }
}

