package com.xebialabs.deployit;

import java.io.*;
import java.util.Arrays;
import java.util.Optional;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;

import com.xebialabs.deployit.errors.LicenseMissingErrorHandler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.ErrorHandler;

public class CustomErrorHandler extends ErrorHandler {

    private final HttpErrorHandler handlers[];

    /** default constructor for backwards compatibility. */
    public CustomErrorHandler() {
        this(new LicenseMissingErrorHandler());
    }

    public CustomErrorHandler(HttpErrorHandler... handlers) {
        this.handlers = handlers;
    }

    @Override
    protected void generateAcceptableResponse(final Request baseRequest, final HttpServletRequest request, final HttpServletResponse response, final int code, final String message, final String mimeType) throws IOException {
        Arrays.stream(handlers)
                .filter(h -> h.canHandle(request, code))
                .findFirst()
                .ifPresent(h -> h.changeResponse(response));
        super.generateAcceptableResponse(baseRequest, request, response, code, message, mimeType);
    }

    @Override
    public void handleErrorPage(HttpServletRequest request, Writer writer, int code, String message)
            throws IOException
    {
        Optional<HttpErrorHandler> handler = Arrays.stream(handlers)
                .filter(h -> h.canHandle(request, code))
                .findFirst();

        if (handler.isPresent()) {
            handler.get().writeErrorContent(writer);
        } else {
            super.handleErrorPage(request, writer, code, message);
        }
    }
}
