package com.xebialabs.deployit;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.Writer;

/**
 * Interface to describe specific handlers for specific error conditions.
 */
public interface HttpErrorHandler {

    /**
     * Can this implementation handle the type of error raised for the request?
     */
    boolean canHandle(HttpServletRequest request, int code);

    /**
     * Write the content of the HTML page to display.
     */
    void writeErrorContent(Writer writer) throws IOException;

    /**
     * Enables a specific handler to change the response.
     */
    default void changeResponse(HttpServletResponse response) {
    };
}
