package com.xebialabs.deployit.setup

import com.xebialabs.deployit.setup.SetupHelperMethods.getBooleanResponse
import com.xebialabs.deployit.setup.UpgradeHelper.DiscoveredPlugin
import grizzled.slf4j.Logging

trait AskAndCopyStrategy extends Logging {

  def createCopyAction(): CopyAction = {
    if (nonInteractiveMode) copyWithNonInteractiveLogMessage
    else if (getBooleanResponse(true)) copyWithInteractiveLogMessage else logNoOp
  }

  val copyWithInteractiveLogMessage: CopyAction

  val copyWithNonInteractiveLogMessage: CopyAction

  val logNoOp: CopyAction

  val nonInteractiveMode: Boolean

}

trait CopyAction {
  def execute(): Unit
}

class PluginAskAndCopyStrategy(override val nonInteractiveMode: Boolean, plugin: DiscoveredPlugin, pluginName: String, destinationSubfolderName: String, previousInstallation: String, fileCopier: FileCopier) extends AskAndCopyStrategy {
  override lazy val copyWithNonInteractiveLogMessage: CopyAction =  new CopyPlugin(s"Copying plugin [$pluginName].")

  override lazy val copyWithInteractiveLogMessage: CopyAction = new CopyPlugin(s"User response was: [yes]. Copying plugin [$pluginName].")

  override lazy val logNoOp: CopyAction = new LogNoOp(s"User response was: [no]. Not copying plugin [$pluginName].")

  private class CopyPlugin(logMsg: String) extends CopyAction with Logging {
    def execute(): Unit = {
      logger.info(logMsg)
      fileCopier.tryCopyPlugin(plugin, destinationSubfolderName, previousInstallation)
    }
  }

}

class FileAskAndCopyStrategy(override val nonInteractiveMode: Boolean, fileType: String, name: String, action: => Unit) extends AskAndCopyStrategy {
  override lazy val copyWithNonInteractiveLogMessage: CopyAction = new CopyFile(s"Copying $fileType [$name].")

  override lazy val copyWithInteractiveLogMessage: CopyAction = new CopyFile(s"User response was: [yes]. Copying $fileType [$name].")

  override lazy val logNoOp: CopyAction = new LogNoOp(s"User response was: [no]. Not copying $fileType [$name].")

  private class CopyFile(logMsg: String) extends CopyAction with Logging {
    def execute(): Unit = {
      logger.info(logMsg)
      action
    }
  }

}

private class LogNoOp(logMsg: String) extends CopyAction with Logging {
  def execute(): Unit = {
    logger.info(logMsg)
  }
}