package com.xebialabs.deployit.jetty;

import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class NoOptionsFilter implements Filter {

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if(request instanceof HttpServletRequest && ((HttpServletRequest) request).getMethod().equals("OPTIONS")) {
            throw new IllegalArgumentException("OPTIONS not supported");
        }
        chain.doFilter(request, response);
    }

    @Override
    public void destroy() {
    }

}
