/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.errors;

import com.xebialabs.deployit.HttpErrorHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;

public class LicenseMissingErrorHandler
implements HttpErrorHandler {
    private String licenseMissingPage = null;

    @Override
    public boolean canHandle(HttpServletRequest request, int code) {
        return code == 402;
    }

    @Override
    public void writeErrorContent(Writer writer) throws IOException {
        if (this.licenseMissingPage == null) {
            this.loadMissingLicensePageContents();
        }
        writer.write(this.licenseMissingPage);
    }

    private void loadMissingLicensePageContents() {
        try (InputStream inputStream = this.getClass().getResourceAsStream("error402page.html");){
            this.licenseMissingPage = new BufferedReader(new InputStreamReader(inputStream)).lines().collect(Collectors.joining());
        }
        catch (IOException | NullPointerException ex) {
            this.useDefaultLicensePageContents();
        }
    }

    private void useDefaultLicensePageContents() {
        this.licenseMissingPage = "<html>\n    <body>\n    This Digital.ai Deploy server will not function due to a license problem. Either it could not be found,\n    it was not properly readable, or it has expired. See the deployit log files for more information.\n<br/><br/>\n    If you would like to continue using Digital.ai Deploy, please contact your Digital.ai sales\n    representative for a new license.\n<br/><br/>\n    Regards,<br/>\n    the Digital.ai team\n    </body>\n</html>";
    }
}

