/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.license.filter;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.license.service.LicenseService;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class LicenseCheckFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(LicenseCheckFilter.class);
    protected LicenseService licenseService;

    public void init(FilterConfig filterConfig) throws ServletException {
        log.trace("Added LicenseCheckFilter to the mix.");
        WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)filterConfig.getServletContext());
        Checks.checkNotNull((Object)ctx, (String)"LicenseCheckFilter: Could not find web application context");
        this.licenseService = (LicenseService)ctx.getBean(LicenseService.class);
        Checks.checkNotNull((Object)this.licenseService, (String)"LicenseCheckFilter: Could not find license check service");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.licenseService.isLicenseExpired() && response instanceof HttpServletResponse) {
            HttpServletResponse hsr = (HttpServletResponse)response;
            hsr.sendError(402, "License expired");
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }
}

