package com.xebialabs.deployit.upgrade;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

import com.xebialabs.deployit.server.api.upgrade.ApplicableRepoTypes;
import com.xebialabs.deployit.server.api.upgrade.RepoType;
import com.xebialabs.deployit.server.api.upgrade.RepositoryInitialization;

import nl.javadude.scannit.Scannit;

public interface InitializationStrategy {

    static Set<Class<? extends RepositoryInitialization>> findApplicableInitializerTypes(RepoType repoType) {
        return Scannit.getInstance().getSubTypesOf(RepositoryInitialization.class).stream()
                .filter(upg -> upg.getAnnotation(ApplicableRepoTypes.class) == null || Arrays.asList(upg.getAnnotation(ApplicableRepoTypes.class).value()).contains(repoType))
                .collect(Collectors.toSet());
    }

    Set<Class<? extends RepositoryInitialization>> findApplicableInitializerTypes();

    void doInitializations(List<RepositoryInitialization> initializations);
}
