package com.xebialabs.deployit.core.defaults

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem

import scala.collection.convert.ImplicitConversions._

class CiDefaultEntityPropertiesProcessor(defaultEntityResolvers: Map[Type, DefaultEntityResolver[_ <: ConfigurationItem]]) {

  def fillDefaultEntities(ciItem: ConfigurationItem): Unit = {
    getDefaultEntitiesForCi(ciItem)
      .map(t => (t._1, t._2.resolveDefaultValue))
      .filter(_._2.isDefined)
      .foreach(t => ciItem.setProperty(t._1, t._2.get))
  }

  private def getDefaultEntitiesForCi(ciItem: ConfigurationItem): Map[String, DefaultEntityResolver[_ <: ConfigurationItem]] = {
    ciItem.getType.getDescriptor.getPropertyDescriptors
      .filter(propertyDescriptor => propertyDescriptor.getReferencedType != null && defaultEntityResolvers.keys.contains(propertyDescriptor.getReferencedType))
      .map(propertyDescriptor => (propertyDescriptor.getName, defaultEntityResolvers(propertyDescriptor.getReferencedType))).toMap
  }

}

