package com.xebialabs.deployit.upgrade;

import com.xebialabs.deployit.server.api.upgrade.ApplicableRepoTypes;
import com.xebialabs.deployit.server.api.upgrade.RepoType;
import com.xebialabs.deployit.server.api.upgrade.Upgrade;
import nl.javadude.scannit.Scannit;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public interface UpgradeStrategy {
    static Set<Class<? extends Upgrade>> findApplicableUpgradeTypes(RepoType repoType) {
        return Scannit.getInstance().getSubTypesOf(Upgrade.class).stream()
                .filter(upg -> upg.getAnnotation(ApplicableRepoTypes.class) == null || Arrays.asList(upg.getAnnotation(ApplicableRepoTypes.class).value()).contains(repoType))
                .collect(Collectors.toSet());
    }

    Set<Class<? extends Upgrade>> findApplicableUpgradeTypes();

    void doUpgrades(List<Upgrade> upgrades);
}
