package com.xebialabs.deployit.spring;

import java.util.Map;
import org.springframework.core.env.EnumerablePropertySource;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;

public class HoconConfigPropertySource extends EnumerablePropertySource<Config> {
    public HoconConfigPropertySource(String name, Config source) {
        super(name, source);
    }

    @Override
    public Object getProperty(String path) {
        try {
            return source.hasPath(path) ? source.getAnyRef(path) : null;
        } catch (ConfigException.BadPath e) {
            return null;
        }
    }

    @Override
    public String[] getPropertyNames() {
        return source.entrySet().stream().map(Map.Entry::getKey).toArray(String[]::new);
    }

    @Override
    public boolean containsProperty(String name) {
        try {
            return source.hasPath(name);
        } catch (ConfigException.BadPath e) {
            return false;
        }
    }
}
