package com.xebialabs.deployit.audit;


import org.springframework.context.ApplicationListener;
import org.springframework.security.authentication.event.AbstractAuthenticationEvent;
import org.springframework.security.authentication.event.AuthenticationFailureBadCredentialsEvent;
import org.springframework.security.authentication.event.AuthenticationSuccessEvent;
import org.springframework.security.authentication.event.LogoutSuccessEvent;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

import com.xebialabs.deployit.engine.spi.event.LoginEvent;
import com.xebialabs.deployit.engine.spi.event.LogoutEvent;
import com.xebialabs.deployit.engine.spi.event.UnsuccessfulLoginEvent;
import com.xebialabs.deployit.event.EventBusHolder;

import static com.xebialabs.deployit.booter.local.utils.Strings.isNotEmpty;

@Component
public class AuthenticationEventListener implements ApplicationListener<AbstractAuthenticationEvent> {

    @Override
    public void onApplicationEvent(final AbstractAuthenticationEvent event) {
        Authentication authentication = event.getAuthentication();

        if (null != authentication && isNotEmpty(authentication.getName())) {
            String username = event.getAuthentication().getName();

            if (event instanceof AuthenticationFailureBadCredentialsEvent) {
                EventBusHolder.publish(new UnsuccessfulLoginEvent(username));
            } else if (event instanceof AuthenticationSuccessEvent) {
                EventBusHolder.publish(new LoginEvent(username));
            } else if (event instanceof LogoutSuccessEvent) {
                EventBusHolder.publish(new LogoutEvent(username));
            }
        }
    }
}
