package com.xebialabs.xlplatform.upgrade

import com.xebialabs.deployit.server.api.upgrade.{Upgrade, UpgradeException, Version}
import nl.javadude.scannit.Scannit
import org.springframework.context.ApplicationContext

import java.lang.reflect.Modifier
import java.util.{List => JList, Set => JSet}
import scala.jdk.CollectionConverters._

object UpgraderHelper {

  def findRecentVersion(upgrades: JList[Upgrade], component: String): Version = if (upgrades.isEmpty) null else upgrades.asScala.max.upgradeVersion()

  def filterApplicable(upgrades: JList[Upgrade], version: Version): JList[Upgrade] = {
    validated(upgrades.asScala.filter(_.shouldBeApplied(version)).toList).sorted.asJava
  }

  def findAndInstantiateSubTypesOf[T](clazz: Class[T], context: ApplicationContext): JSet[T] = instantiateClasses[T](Scannit.getInstance.getSubTypesOf[T](clazz), context)

  def instantiateClasses[T](classes: JSet[java.lang.Class[_ <: T]], context: ApplicationContext):JSet[T] =
  classes.asScala.filter { clazz =>
    !Modifier.isAbstract(clazz.getModifiers)
  }.map { clazz =>
    context.getAutowireCapableBeanFactory.createBean(clazz)
  }.asJava

  private def validated(upgrades: List[Upgrade]): List[Upgrade] = {
    upgrades.filter(_.upgradeVersion().getDataModel != 0).groupBy(u => u.upgradeVersion()).collect {
      case (version, uu) if uu.size > 1 =>
        val upgrades = uu.map(u => s"${u.getClass.getSimpleName} (${u.upgradeVersion()})")
        throw new UpgradeException(s"Found ${uu.size} upgrades version $version: ${upgrades.mkString(", ")}")
    }

    upgrades
  }
}
