package com.xebialabs.deployit.repository;

import com.xebialabs.deployit.core.*;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;

import java.util.*;


public class ConfigurationItemCloner {

    @SuppressWarnings("unchecked")
    public static <T extends ConfigurationItem> T cloneShallow(T configurationItem) {
        Descriptor descriptor = configurationItem.getType().getDescriptor();
        T newInstance = descriptor.<T>newInstance(configurationItem.getId());
        for (PropertyDescriptor pd : descriptor.getPropertyDescriptors()) {
            switch (pd.getKind()) {
                case BOOLEAN:
                case INTEGER:
                case STRING:
                case ENUM:
                case DATE:
                    pd.set(newInstance, pd.get(configurationItem));
                    break;
                case CI:
                    pd.set(newInstance, pd.get(configurationItem));
                    break;
                case SET_OF_STRING:
                    Set<String> o = (Set<String>) pd.get(configurationItem);
                    if (o instanceof SetOfStringView) {
                        Set<StringValue> wrapped = ((SetOfStringView) o).getWrapped();
                        pd.set(newInstance, new SetOfStringView(new HashSet<>(wrapped)));
                    } else {
                        pd.set(newInstance, new HashSet<>(o));
                    }
                    break;
                case SET_OF_CI:
                    pd.set(newInstance, new HashSet<>((Set<ConfigurationItem>) pd.get(configurationItem)));
                    break;
                case LIST_OF_STRING:
                    List<String> l = (List<String>) pd.get(configurationItem);
                    if (l instanceof ListOfStringView) {
                        List<StringValue> wrapped = ((ListOfStringView) l).getWrapped();
                        pd.set(newInstance, new ListOfStringView(new ArrayList<>(wrapped)));
                    } else {
                        pd.set(newInstance, new ArrayList<>(l));
                    }
                    break;
                case LIST_OF_CI:
                    pd.set(newInstance, new ArrayList<>((List<ConfigurationItem>) pd.get(configurationItem)));
                    break;
                case MAP_STRING_STRING:
                    Map<String, String> m = (Map<String, String>) pd.get(configurationItem);
                    if (m instanceof MapStringStringView) {
                        Map<String, StringValue> wrapped = ((MapStringStringView) m).getWrapped();
                        pd.set(newInstance, new MapStringStringView(new HashMap<>(wrapped)));
                    } else {
                        pd.set(newInstance, new HashMap<>(m));
                    }
                    break;
                default:
                    throw new IllegalStateException("Unsupported type: " + pd.getKind());
            }
        }
        return newInstance;
    }
}
