package com.xebialabs.deployit.core.defaults

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem
import nl.javadude.scannit.Scannit
import org.springframework.context.annotation.{Bean, Configuration}

import java.lang.reflect.Modifier
import scala.jdk.CollectionConverters._

@Configuration
class CiDefaultEntityResolverConfiguration {

  @Bean
  def defaultEntityPropertiesProcessor(): CiDefaultEntityPropertiesProcessor = {
    new CiDefaultEntityPropertiesProcessor(
      Scannit.getInstance.getSubTypesOf(classOf[DefaultEntityResolver[_ <: ConfigurationItem]])
        .asScala
        .filterNot(c => Modifier.isAbstract(c.getModifiers))
        .map(_.newInstance())
        .map { instance =>
          (instance.resolvedType, instance)
        }.toMap)
  }

}
