package com.xebialabs.deployit.audit;

import nl.javadude.t2bus.Subscribe;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.xebialabs.deployit.engine.spi.event.AuditableDeployitEvent;
import com.xebialabs.deployit.engine.spi.event.CiBaseEvent;
import com.xebialabs.deployit.engine.spi.event.DeployitEventListener;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;

/**
 * This event listener logs auditable events using our standard logging facilities.
 */
@DeployitEventListener
public class TextLoggingAuditableEventListener {

    private final CiFormatter formatter;

    public TextLoggingAuditableEventListener() {
        formatter = new CiFormatter();
    }

    @Subscribe
    public void log(AuditableDeployitEvent event) {
        Logger logger = LoggerFactory.getLogger("audit." + event.component);
        if (logger.isInfoEnabled()) {
            logger.info("{} - {}", event.username, event.message);
            if (event instanceof CiBaseEvent) {
                CiBaseEvent ciEvent = (CiBaseEvent) event;
                for (ConfigurationItem ci : ciEvent.getCis()) {
                    logger.info("{} -     CI [{}]:\n{}", event.username, ci.getId(), formatter.format(ci));
                }
            }
        }

    }
}
