package com.xebialabs.deployit.core.xml

import java.util

import com.xebialabs.deployit.core.{AbstractStringView, MapStringStringView, StringValue}
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor
import com.xebialabs.deployit.repository.StringValueConverter.valueToString
import com.xebialabs.deployit.util.PasswordEncrypter
import com.xebialabs.xltype.serialization.CiWriter

import scala.collection.JavaConverters.{collectionAsScalaIterableConverter, mapAsJavaMapConverter, mapAsScalaMapConverter, seqAsJavaListConverter}

class PasswordMaskingCiConverter extends PasswordEncryptingCiConverter {
  private var passwordEncrypter: PasswordEncrypter = PasswordEncrypter.getInstance
  private val PASSWORD_MASK: String = "********"

  setWriteValidationMessages(true)

  override protected[xml] def writeStringProperty(value: Any, propertyDescriptor: PropertyDescriptor, writer: CiWriter): Unit =
    if (propertyDescriptor.isPassword) {
      writer.valueAsString(PASSWORD_MASK)
    } else {
      super.writeStringProperty(value, propertyDescriptor, writer)
    }

  override protected[xml] def writeCollectionOfStringProperty(value: Any, propertyDescriptor: PropertyDescriptor, writer: CiWriter): Unit =
    super.writeCollectionOfStringProperty(value match {
      case collection: StringViewType => collection.getWrapped.asScala.map(
        (v: StringValue) =>
          if (propertyDescriptor.isPassword)
            new StringValue(PASSWORD_MASK)
          else
            convertToString(v)).toSeq.asJava
      case _ => value
    }, propertyDescriptor, writer)

  override protected[xml] def writeMapStringStringProperty(value: Any, propertyDescriptor: PropertyDescriptor, writer: CiWriter): Unit = {
    super.writeMapStringStringProperty(value match {
      case map: MapStringStringView => map.getWrapped.asScala.map{
        case (k, v) =>
          if (propertyDescriptor.isPassword)
            (k, new StringValue(PASSWORD_MASK))
          else
            (k, convertToString(v))
      }.asJava
      case _ => value
    }, propertyDescriptor, writer)
  }

  private def convertToString(v: StringValue) = valueToString(passwordEncrypter, true).apply(v)

  type StringViewType = AbstractStringView[_ <: util.Collection[StringValue]]

}
