/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.core.api.jaxb;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;


@XmlType(name = "map")
public class MapMapElement {

    private MapEntry[] mapEntries = new MapEntry[0];

    public MapMapElement() {
    }

    public MapMapElement(final Map<String, String> map) {
        List<MapEntry> entries = new ArrayList<>();
        for (Map.Entry<String, String> eachEntry : map.entrySet()) {
            entries.add(new MapEntry(eachEntry));
        }
        this.mapEntries = entries.toArray(new MapEntry[entries.size()]);
    }

    @XmlElement(name = "map")
    public MapEntry[] getMapEntries() {
        return mapEntries;
    }

    public void setMapEntries(MapEntry[] map) {
        this.mapEntries = map;
    }

    @XmlTransient
    public Map<String, String> getMap() {
        Map<String, String> m = new HashMap<>();
        for (MapEntry eachEntry : mapEntries) {
            m.put(eachEntry.getKey(), eachEntry.getValue());
        }
        return m;
    }

    @XmlRootElement()
    public static class MapEntry {
        private String key;

        private String value;

        public MapEntry() {
        }

        public MapEntry(Map.Entry<String, String> mapEntry) {
            this.key = mapEntry.getKey();
            this.value = mapEntry.getValue();
        }

        public String getKey() {
            return key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return value;
        }

        public void setValue(String value) {
            this.value = value;
        }

    }

}
