/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.core.rest.api.support

import com.xebialabs.deployit.engine.api.dto.Paging
import org.jboss.resteasy.spi.{HttpResponse, ResteasyProviderFactory}

object PaginationSupport {

  private def addHeader(response: HttpResponse, headerKey: String, someRef: AnyRef): Unit =
    // as apis are called from jython it might happen that we don't have HttpResponse
    if (response != null && ResteasyProviderFactory.getInstance().getContextData(classOf[HttpResponse]) != null) {
      response.getOutputHeaders.putSingle(headerKey, someRef)
    }

  def addTotalCountHeader(totalCount: Long, response: HttpResponse): Unit =
    addHeader(response, Paging.X_TOTAL_COUNT_HEADER, Long.box(totalCount))

  def addHasNextPageHeader(hasNext: Boolean, response: HttpResponse): Unit =
    addHeader(response, Paging.X_HAS_NEXT_PAGE_HEADER, Boolean.box(hasNext))
}
