/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.core.api.dto;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xebialabs.deployit.engine.api.dto.AbstractDto;

import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.PeriodType;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

@XmlRootElement(name = "license-info")
public class LicenseDto extends AbstractDto {

    private DateTimeFormatter dtf = DateTimeFormat.forPattern("yyyy-MM-dd");

    /**
     *     LICENSED_TO("Licensed to", true, STRING),
     CONTACT("Contact", true, STRING),
     EXPIRES_AFTER("Expires after", true, DATE),
     PRODUCT("Product", true, STRING),
     REPOSITORY_ID("Repository id", false, STRING),
     MAX_NUMBER_OF_USERS("Maximum number of users", false, STRING),
     MAX_NUMBER_OF_CIS("Licensed number of configuration items", false, MAP_STRING_INTEGER),
     LICENSED_PLUGINS("Licensed plugins", false, LIST_OF_STRINGS),
     SUPPORT_POLICY("Support policy", false, STRING);

     */
    private String product;
    private String licensedTo;
    private String contact;
    private String expiresAfter;
    private String remainingDays;
    private List<LicensedCiUsageDto> licensedCiUsages = new ArrayList<>();
    private List<String> licensedPlugins = new ArrayList<>();
    private String supportPolicy;
    private String maxUsers;
    private String edition;

    public LicenseDto() {
    }

    public LicenseDto(String product, String licensedTo, String contact) {
        this.product = product;
        this.licensedTo = licensedTo;
        this.contact = contact;
    }

    private String calculateRemainingDays(String toBeExpiresAfter) {
        DateTime expiredDate = dtf.parseDateTime(toBeExpiresAfter);
        Period period = new Period(getCurrentTime(), expiredDate, PeriodType.dayTime());
        // The days is increased on one, because period.getDays() returns the whole days, don't consider hours, minutes.
        return String.valueOf(period.getDays() + 1);
    }

    @XmlElement(name = "product")
    public String getProduct() {
        return product;
    }

    public void setProduct(String product) {
        this.product = product;
    }

    @XmlElement(name = "licensed-to")
    public String getLicensedTo() {
        return licensedTo;
    }

    public void setLicensedTo(String licencedTo) {
        this.licensedTo = licencedTo;
    }

    @XmlElement(name = "contact")
    public String getContact() {
        return contact;
    }

    public void setContact(String contact) {
        this.contact = contact;
    }

    @XmlElement(name = "expires-after")
    public String getExpiresAfter() {
        return expiresAfter;
    }

    @XmlElement(name = "remaining-days")
    public String getRemainingDays() {
        return remainingDays;
    }

    public void setExpiresAfter(String toBeExpiresAfter) {
        this.expiresAfter = toBeExpiresAfter;
        this.remainingDays = toBeExpiresAfter != null ? calculateRemainingDays(toBeExpiresAfter) : null;
    }

    @XmlElement(name = "licensed-ci-usage")
    @JsonProperty("licensedCiUsage")
    public List<LicensedCiUsageDto> getLicensedCiUsages() {
        return licensedCiUsages;
    }

    public void setLicensedCiUsages(List<LicensedCiUsageDto> licensedCiUsages) {
        this.licensedCiUsages = licensedCiUsages;
    }

    @XmlElement(name = "licensed-plugin")
    public List<String> getLicensedPlugins() {
        return licensedPlugins;
    }

    public void setLicensedPlugins(List<String> licensedPlugins) {
        this.licensedPlugins = licensedPlugins;
    }

    @XmlElement(name = "support-policy")
    public String getSupportPolicy() {
        return supportPolicy;
    }

    public void setSupportPolicy(String supportPolicy) {
        this.supportPolicy = supportPolicy;
    }

    @XmlElement(name = "max-users")
    public String getMaxUsers() {
        return maxUsers;
    }

    public void setMaxUsers(String maxUsers) {
        this.maxUsers = maxUsers;
    }

    @XmlElement(name = "edition")
    public String getEdition() {
        return edition;
    }

    public void setEdition(String edition) {
        this.edition = edition;
    }

    public DateTime getCurrentTime() {
        return DateTime.now();
    }
}
