/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.core.api;

import java.util.List;

import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;

import com.xebialabs.deployit.core.api.dto.RolePermissions;
import com.xebialabs.deployit.engine.api.security.RolePrincipals;
import com.xebialabs.deployit.engine.api.dto.Ordering;
import com.xebialabs.deployit.engine.api.dto.Paging;
import com.xebialabs.deployit.engine.api.security.Role;

@Path("/internal/security")
@Consumes({ MediaType.APPLICATION_XML, MediaType.APPLICATION_JSON })
@Produces({ MediaType.APPLICATION_XML, MediaType.APPLICATION_JSON })
public interface InternalSecurityProxy {

	/**
	 * Method @Deprecated use com.xebialabs.deployit.engine.api.RoleService.exists(String) instead
	 * Checks if role with given name exists
	 *
	 * @param roleName checked role name
	 * @return
	 */
	@Deprecated
    @GET
    @Path("exists/{name}")
    Boolean exists(@PathParam("name") String roleName);

	/**
	 * Method @Deprecated use com.xebialabs.deployit.engine.api.RoleService.list(String, String, Paging, Ordering) instead
	 * List the roles for given configuration item ID
	 *
	 * @param id configuration item ID
	 * @param rolePattern the role name pattern used for search
	 * @param paging search paging
	 * @param order search order
	 * @return
	 */
	@Deprecated
    @GET
    @Path("roles/v2/{id:.+}")
    List<Role> list(@PathParam("id") String id,
                    @QueryParam("rolePattern") String rolePattern,
                    @BeanParam Paging paging,
                    @QueryParam("order") Ordering order);

	/**
	 * Method @Deprecated use com.xebialabs.deployit.engine.api.RoleService.list() instead
	 * Lists the names of all available roles in the security system.
	 *
	 * @return a list of role names.
	 */
	@Deprecated
    @GET
    @Path("roles")
    default List<Role> list() {
        return this.list("global", null, null, null);
    }

	/**
	 * Method @Deprecated use com.xebialabs.deployit.engine.api.RoleService.readRolePrincipals(String, Paging, Ordering) instead
	 * Lists paged role principals available in the security system for given role name pattern
	 *
	 * @param rolePattern the role name pattern used for search
	 * @param paging search paging
	 * @param order search order
	 */
	@Deprecated
	@GET
    @Path("roles/v2/principals")
    List<RolePrincipals> readRolePrincipals(@QueryParam("rolePattern") String rolePattern,
                                            @BeanParam Paging paging,
                                            @QueryParam("order") Ordering order);

	/**
	 * Method @Deprecated use com.xebialabs.deployit.engine.api.RoleService.readRolePrincipals() instead
	 * Lists all role principals available in the security system.
	 *
	 */
	@Deprecated
    @GET
    @Path("roles/principals")
    default List<RolePrincipals> readRolePrincipals() {
        return this.readRolePrincipals(null, null, null);
    }

	/**
	 * Lists all role principals available in the security system.
	 *
	 * @param rolePrincipals the list of all RolePrincipals to be overwrite old ones
	 */
    @POST
    @Path("roles/principals")
    void writeRolePrincipals(List<RolePrincipals> rolePrincipals);

    @GET
    @Path("roles/v2/permissions/{id:.+}")
    List<RolePermissions> readRolePermissions(@PathParam("id") String id,
                                              @QueryParam("rolePattern") String rolePattern,
                                              @BeanParam Paging paging,
                                              @QueryParam("order") Ordering order,
											  @DefaultValue("false") @QueryParam("includeInherited") Boolean includeInherited);

	default List<RolePermissions> readRolePermissions(String id,
											  String rolePattern,
											  Paging paging,
											  Ordering order) {
		return this.readRolePermissions(id, rolePattern, paging, order, false);
	}

    // NOTICE: wrong name of method - not changing because of backward compatibility?
    @GET
    @Path("roles/permissions/{id:.+}")
    default List<RolePermissions> readRolePrincipals(@PathParam("id") String id) {
        return this.readRolePermissions(id, null, null, null);
    }

    @POST
    @Path("roles/permissions/{id:.+}")
    void writeRolePermissions(@PathParam("id") String id, List<RolePermissions> permissions);

}
