package com.xebialabs.deployit.core.rest.api

import java.io.OutputStream

import com.xebialabs.deployit.core.api.{SupportProxy, SupportService}
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource
import com.xebialabs.deployit.security.permission.PlatformPermissions.ADMIN
import com.xebialabs.xltype.serialization.util.DateUtil
import javax.ws.rs.core.{Response, StreamingOutput}
import org.joda.time.DateTime
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Controller

import scala.collection.JavaConverters._

@Controller
class SupportResource(@Autowired() supportService: SupportService,
                      @Autowired() supportAcceleratorConfiguration: SupportAcceleratorConfiguration)
  extends AbstractSecuredResource with SupportProxy {

  override def generateSupportZip(): Response = {
    checkPermission(ADMIN)

    val timestamp = DateUtil.toString(DateTime.now())
    val filename = s"${supportAcceleratorConfiguration.filename}-$timestamp.zip"

    val stream = new StreamingOutput {
      override def write(output: OutputStream): Unit =
        supportService.prepareSupportZip(output,
          supportAcceleratorConfiguration.directoriesToPack.asJava,
          supportAcceleratorConfiguration.directoriesToList.asJava,
          supportAcceleratorConfiguration.internalReportsToPack.asJava)
    }

    Response
      .ok(stream)
      .header("Content-Disposition", "attachment; filename=\"" + filename + "\"")
      .build
  }
}
