package com.xebialabs.deployit.core.rest.secured;

import com.xebialabs.deployit.security.PermissionDeniedException;
import com.xebialabs.deployit.security.permission.Permission;

/**
 */
public abstract class AbstractSecuredResource {

    protected void checkPermission(Permission permission) {
        checkPermission(permission, null);
    }

    protected void checkPermission(Permission permission, String id) {
        if (!permission.getPermissionHandler().hasPermission(id)) {
            throw PermissionDeniedException.forPermission(permission, id);
        }
    }

    protected boolean hasPermission(Permission permission) {
        return hasPermission(permission, null);
    }

    protected boolean hasPermission(Permission permission, String id) {
        return permission.getPermissionHandler().hasPermission(id);
    }

}
