package com.xebialabs.deployit.core.rest.api;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

import com.xebialabs.deployit.core.api.dto.RolePermissions;
import com.xebialabs.deployit.engine.api.security.RolePrincipals;
import com.xebialabs.deployit.engine.api.dto.ConfigurationItemId;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.ConfigurationItemData;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.permission.Permission;

import static java.lang.String.format;

@Component
public class DtoReader {

    public static final Function<ConfigurationItem, ConfigurationItemId> ciToCiId = ci -> new ConfigurationItemId(ci.getId(), ci.getType());

    public static final Function<ConfigurationItemData, ConfigurationItemId> ciDataToCiId = cid -> new ConfigurationItemId(cid.getId(), cid.getType());

    public static final Function<ConfigurationItemId, ConfigurationItemData> ciIdToCiData = input -> new ConfigurationItemData(input.getId(), input.getType());

    public List<Role> readRoleAssignments(List<RolePrincipals> assignments) {
        List<Role> roles = new ArrayList<>();
        for (RolePrincipals roleAssignment : assignments) {
            com.xebialabs.deployit.engine.api.security.Role roleDto = roleAssignment.getRole();
            Role role = asRole(roleDto);
            List<String> principals = roleAssignment.getPrincipals();
            role.getPrincipals().addAll(principals);
            roles.add(role);
        }

        return roles;
    }

    private static Role asRole(com.xebialabs.deployit.engine.api.security.Role roleDto) {
        return new Role(roleDto.getId(), roleDto.getName());
    }


    public Map<Role, Set<Permission>> readRolePermissions(List<RolePermissions> permissions, List<Role> roles) {
        Map<Role, Set<Permission>> map = new HashMap<>();
        for (RolePermissions rolePermission : permissions) {
            Role role = asRole(rolePermission.getRole());
            if (role.getId() == null) {
                role = findRole(role.getName(), roles);
            }
            Set<Permission> collect = rolePermission.getPermissions().stream()
                    .map(Permission::find)
                    .filter(Objects::nonNull)
                    .collect(Collectors.toSet());
            map.put(role, collect);
        }
        return map;
    }

    private static Role findRole(String name, List<Role> roles) {
        for (Role role : roles) {
            if (role.getName().equals(name)) {
                return role;
            }
        }
        throw new IllegalArgumentException(format("Couldn't find role with name [%s]", name));
    }
}
