package com.xebialabs.deployit.core.rest.api;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.xebialabs.deployit.core.api.dto.LicensedCiUsageDto;
import com.xebialabs.license.License;
import com.xebialabs.license.LicenseCiCounter;
import com.xebialabs.license.LicenseProperty;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.core.api.ConfigurationService;
import com.xebialabs.deployit.core.api.dto.LicenseDto;
import com.xebialabs.license.service.LicenseService;

import static com.xebialabs.deployit.ServerConfiguration.*;

@Controller
public class ConfigurationResource implements ConfigurationService {

    private final ServerConfiguration config;
    private final LicenseService licenseService;

    @Autowired
    public ConfigurationResource(ServerConfiguration config, LicenseService licenseService) {
        this.config = config;
        this.licenseService = licenseService;
    }

    @Override
    public Map<String, String> getProperties() {
        Map<String, String> properties = new HashMap<>();

        properties.put(KEY_CLIENT_SESSION_TIMEOUT_MINUTES, Integer.toString(config.getClientSessionTimeoutMinutes()));
        properties.put(KEY_CLIENT_SESSION_REMEMBER_ENABLED, Boolean.toString(config.isClientSessionRememberEnabled()));
        properties.put(KEY_CLIENT_AUTOMATICALLY_MAP_ALL_DEPLOYABLES, Boolean.toString(config.isClientAutomaticallyMapAllDeployables()));
        properties.put(KEY_CLIENT_AUTOMATICALLY_MAP_ALL_DEPLOYABLES_ON_INITIAL, Boolean.toString(config.isClientAutomaticallyMapAllDeployablesOnInitial()));
        properties.put(KEY_CLIENT_AUTOMATICALLY_MAP_ALL_DEPLOYABLES_ON_UPDATE, Boolean.toString(config.isClientAutomaticallyMapAllDeployablesOnUpdate()));
        properties.put(KEY_CLIENT_SERVER_POLL_DELAY, Integer.toString(config.getClientServerPollDelay()));

        return properties;
    }

    @Override
    public LicenseDto getLicenseInfo() {
        License license = licenseService.getLicense();
        LicenseDto licenseDto = new LicenseDto(
                license.getStringValue(LicenseProperty.PRODUCT),
                license.getStringValue(LicenseProperty.LICENSED_TO),
                license.getStringValue(LicenseProperty.CONTACT));
        String expiresAfter = license.getStringValue(LicenseProperty.EXPIRES_AFTER);
        licenseDto.setExpiresAfter(expiresAfter);
        LicenseCiCounter.LicensedCiUse[] ciUses = licenseService.getCounter().licensedCisInUse();
        for (LicenseCiCounter.LicensedCiUse ciUse : ciUses) {
            licenseDto.getLicensedCiUsages().add(
                    new LicensedCiUsageDto(ciUse.type().toString(), ciUse.allowedAmount(), ciUse.actualAmount()));
        }
        licenseDto.setSupportPolicy(license.getStringValue(LicenseProperty.SUPPORT_POLICY));
        licenseDto.setEdition(license.getStringValue(LicenseProperty.EDITION));
        List<String> plugins = license.getListValue(LicenseProperty.LICENSED_PLUGINS);
        licenseDto.setMaxUsers(license.getStringValue(LicenseProperty.MAX_NUMBER_OF_USERS));
        licenseDto.getLicensedPlugins().addAll(plugins);
        return licenseDto;
    }
}
